/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.string.UTF8;

public enum StoreFile {
    NODE_STORE("NodeStore", ".nodestore.db", StandardV2_0.STORE_VERSION),
    NODE_LABEL_STORE("ArrayPropertyStore", ".nodestore.db.labels", StandardV2_0.STORE_VERSION),
    PROPERTY_STORE("PropertyStore", ".propertystore.db", StandardV2_0.STORE_VERSION),
    PROPERTY_ARRAY_STORE("ArrayPropertyStore", ".propertystore.db.arrays", StandardV2_0.STORE_VERSION),
    PROPERTY_STRING_STORE("StringPropertyStore", ".propertystore.db.strings", StandardV2_0.STORE_VERSION),
    PROPERTY_KEY_TOKEN_STORE("PropertyIndexStore", ".propertystore.db.index", StandardV2_0.STORE_VERSION),
    PROPERTY_KEY_TOKEN_NAMES_STORE("StringPropertyStore", ".propertystore.db.index.keys", StandardV2_0.STORE_VERSION),
    RELATIONSHIP_STORE("RelationshipStore", ".relationshipstore.db", StandardV2_0.STORE_VERSION),
    RELATIONSHIP_GROUP_STORE("RelationshipGroupStore", ".relationshipgroupstore.db", StandardV2_1.STORE_VERSION),
    RELATIONSHIP_TYPE_TOKEN_STORE("RelationshipTypeStore", ".relationshiptypestore.db", StandardV2_0.STORE_VERSION),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("StringPropertyStore", ".relationshiptypestore.db.names", StandardV2_0.STORE_VERSION),
    LABEL_TOKEN_STORE("LabelTokenStore", ".labeltokenstore.db", StandardV2_0.STORE_VERSION),
    LABEL_TOKEN_NAMES_STORE("StringPropertyStore", ".labeltokenstore.db.names", StandardV2_0.STORE_VERSION),
    SCHEMA_STORE("SchemaStore", ".schemastore.db", StandardV2_0.STORE_VERSION),
    COUNTS_STORE_LEFT("CountsStore", ".counts.db.a", StandardV2_2.STORE_VERSION, false){

        @Override
        boolean isOptional() {
            return true;
        }
    }
    ,
    COUNTS_STORE_RIGHT("CountsStore", ".counts.db.b", StandardV2_2.STORE_VERSION, false){

        @Override
        boolean isOptional() {
            return true;
        }
    }
    ,
    NEO_STORE("NeoStore", "", StandardV2_0.STORE_VERSION);

    private final String typeDescriptor;
    private final String storeFileNamePart;
    private final String sinceVersion;
    private final boolean recordStore;

    private StoreFile(String typeDescriptor, String storeFileNamePart, String sinceVersion) {
        this(typeDescriptor, storeFileNamePart, sinceVersion, true);
    }

    private StoreFile(String typeDescriptor, String storeFileNamePart, String sinceVersion, boolean recordStore) {
        this.typeDescriptor = typeDescriptor;
        this.storeFileNamePart = storeFileNamePart;
        this.sinceVersion = sinceVersion;
        this.recordStore = recordStore;
    }

    public String forVersion(String version) {
        return this.typeDescriptor + " " + version;
    }

    public String fileName(StoreFileType type) {
        return type.augment("neostore" + this.storeFileNamePart);
    }

    public String storeFileName() {
        return this.fileName(StoreFileType.STORE);
    }

    public String fileNamePart() {
        return this.storeFileNamePart;
    }

    public boolean isRecordStore() {
        return this.recordStore;
    }

    public static Iterable<StoreFile> legacyStoreFilesForVersion(String version) {
        Predicate<StoreFile> predicate = item -> version.compareTo(item.sinceVersion) >= 0;
        Iterable<StoreFile> storeFiles = StoreFile.currentStoreFiles();
        Iterable filter = Iterables.filter(predicate, storeFiles);
        return filter;
    }

    public static Iterable<StoreFile> currentStoreFiles() {
        return Iterables.iterable((Object[])StoreFile.values());
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, File fromDirectory, File toDirectory, StoreFile ... files) throws IOException {
        StoreFile.fileOperation(operation, fs, fromDirectory, toDirectory, StoreFile.storeFiles(files), false, ExistingTargetStrategy.FAIL);
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile> files, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy) throws IOException {
        StoreFile.fileOperation(operation, fs, fromDirectory, toDirectory, files, allowSkipNonExistentFiles, existingTargetStrategy, StoreFileType.values());
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile> files, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy, StoreFileType ... types) throws IOException {
        for (StoreFile storeFile : files) {
            for (StoreFileType type : types) {
                String fileName = storeFile.fileName(type);
                operation.perform(fs, fileName, fromDirectory, allowSkipNonExistentFiles, toDirectory, existingTargetStrategy);
            }
        }
    }

    public static void removeTrailers(String version, FileSystemAbstraction fs, File storeDir, int pageSize) throws IOException {
        for (StoreFile storeFile : StoreFile.legacyStoreFilesForVersion(StandardV3_0.STORE_VERSION)) {
            long fileSize;
            String trailer = storeFile.forVersion(version);
            byte[] encodedTrailer = UTF8.encode((String)trailer);
            File file = new File(storeDir, storeFile.storeFileName());
            long truncationPosition = StoreFile.containsTrailer(fs, file, fileSize = fs.getFileSize(file), pageSize, encodedTrailer);
            if (truncationPosition == -1L) continue;
            fs.truncate(file, truncationPosition);
        }
    }

    private static long containsTrailer(FileSystemAbstraction fs, File file, long fileSize, int pageSize, byte[] encodedTrailer) throws IOException {
        if (!fs.fileExists(file)) {
            return -1L;
        }
        try (StoreChannel channel = fs.open(file, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(encodedTrailer.length);
            long stopPosition = Math.max(0L, fileSize - (long)encodedTrailer.length - (long)pageSize);
            for (long newPosition = Math.max(0L, fileSize - (long)encodedTrailer.length); newPosition >= stopPosition; --newPosition) {
                int read;
                channel.position(newPosition);
                int totalRead = 0;
                do {
                    if ((read = channel.read(buffer)) != -1) continue;
                    long l = -1L;
                    return l;
                } while ((totalRead += read) < encodedTrailer.length);
                if (Arrays.equals(buffer.array(), encodedTrailer)) {
                    long l = newPosition;
                    return l;
                }
                buffer.clear();
            }
            long l = -1L;
            return l;
        }
    }

    boolean isOptional() {
        return false;
    }

    public static Iterable<StoreFile> storeFiles(StoreFile ... files) {
        return Iterables.iterable((Object[])files);
    }
}

