/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.ListConverter;
import org.neo4j.kernel.impl.proc.MapConverter;
import org.neo4j.kernel.impl.proc.Neo4jValue;
import org.neo4j.procedure.Name;

public class TypeMappers {
    private final Map<Type, NeoValueConverter> javaToNeo = new HashMap<Type, NeoValueConverter>();
    private final NeoValueConverter TO_ANY = new SimpleConverter(Neo4jTypes.NTAny, Object.class);
    private final NeoValueConverter TO_STRING = new SimpleConverter(Neo4jTypes.NTString, String.class, Neo4jValue::ntString);
    private final NeoValueConverter TO_INTEGER = new SimpleConverter(Neo4jTypes.NTInteger, Long.class, s -> Neo4jValue.ntInteger(Long.parseLong(s)));
    private final NeoValueConverter TO_FLOAT = new SimpleConverter(Neo4jTypes.NTFloat, Double.class, s -> Neo4jValue.ntFloat(Double.parseDouble(s)));
    private final NeoValueConverter TO_NUMBER = new SimpleConverter(Neo4jTypes.NTNumber, Number.class, s -> {
        try {
            return Neo4jValue.ntInteger(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return Neo4jValue.ntFloat(Double.parseDouble(s));
        }
    });
    private final NeoValueConverter TO_BOOLEAN = new SimpleConverter(Neo4jTypes.NTBoolean, Boolean.class, s -> Neo4jValue.ntBoolean(Boolean.parseBoolean(s)));
    private final NeoValueConverter TO_MAP = new SimpleConverter(Neo4jTypes.NTMap, Map.class, new MapConverter());
    private final NeoValueConverter TO_LIST = this.toList(this.TO_ANY, (Type)((Object)Object.class));

    public TypeMappers() {
        this.registerScalarsAndCollections();
    }

    private void registerScalarsAndCollections() {
        this.registerType(String.class, this.TO_STRING);
        this.registerType(Long.TYPE, this.TO_INTEGER);
        this.registerType(Long.class, this.TO_INTEGER);
        this.registerType(Double.TYPE, this.TO_FLOAT);
        this.registerType(Double.class, this.TO_FLOAT);
        this.registerType(Number.class, this.TO_NUMBER);
        this.registerType(Boolean.TYPE, this.TO_BOOLEAN);
        this.registerType(Boolean.class, this.TO_BOOLEAN);
        this.registerType(Map.class, this.TO_MAP);
        this.registerType(List.class, this.TO_LIST);
        this.registerType(Object.class, this.TO_ANY);
    }

    public Neo4jTypes.AnyType neoTypeFor(Type javaType) throws ProcedureException {
        return this.converterFor(javaType).type();
    }

    public NeoValueConverter converterFor(Type javaType) throws ProcedureException {
        NeoValueConverter converter = this.javaToNeo.get(javaType);
        if (converter != null) {
            return converter;
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type rawType = pt.getRawType();
            if (rawType == List.class) {
                Type type = pt.getActualTypeArguments()[0];
                return this.toList(this.converterFor(type), type);
            }
            if (rawType == Map.class) {
                Type type = pt.getActualTypeArguments()[0];
                if (type != String.class) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Maps are required to have `String` keys - but this map has `%s` keys.", type.getTypeName());
                }
                return this.TO_MAP;
            }
        }
        throw this.javaToNeoMappingError(javaType);
    }

    public void registerType(Class<?> javaClass, NeoValueConverter toNeo) {
        this.javaToNeo.put(javaClass, toNeo);
    }

    private NeoValueConverter toList(NeoValueConverter inner, Type type) {
        return new SimpleConverter(Neo4jTypes.NTList(inner.type()), List.class, new ListConverter(type, inner.type()));
    }

    private ProcedureException javaToNeoMappingError(Type cls) {
        List types = Iterables.asList(this.javaToNeo.keySet());
        types.sort((a, b) -> a.toString().compareTo(b.toString()));
        return new ProcedureException((Status)Status.Statement.TypeError, "Don't know how to map `%s` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: %s", cls, types);
    }

    public static class SimpleConverter
    implements NeoValueConverter {
        private final Neo4jTypes.AnyType type;
        private final Class<?> javaClass;
        private final Function<String, Neo4jValue> defaultConverter;

        public SimpleConverter(Neo4jTypes.AnyType type, Class<?> javaClass) {
            this(type, javaClass, SimpleConverter.nullParser(javaClass, type));
        }

        public SimpleConverter(Neo4jTypes.AnyType type, Class<?> javaClass, Function<String, Neo4jValue> defaultConverter) {
            this.type = type;
            this.javaClass = javaClass;
            this.defaultConverter = defaultConverter;
        }

        @Override
        public Optional<Neo4jValue> defaultValue(Name parameter) throws ProcedureException {
            String defaultValue = parameter.defaultValue();
            if (defaultValue.equals(" <[6795b15e-8693-4a21-b57a-4a7b87f09a5a]> ")) {
                return Optional.empty();
            }
            try {
                return Optional.of(this.defaultConverter.apply(defaultValue));
            }
            catch (Exception e) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Default value `%s` could not be parsed as a %s", parameter.defaultValue(), this.javaClass.getSimpleName());
            }
        }

        @Override
        public Neo4jTypes.AnyType type() {
            return this.type;
        }

        @Override
        public Object toNeoValue(Object javaValue) throws ProcedureException {
            if (javaValue == null || this.javaClass.isInstance(javaValue)) {
                return javaValue;
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Expected `%s` to be a `%s`, found `%s`.", javaValue, this.javaClass.getSimpleName(), javaValue.getClass());
        }

        private static Function<String, Neo4jValue> nullParser(Class<?> javaType, Neo4jTypes.AnyType neoType) {
            return s -> {
                if (s.equalsIgnoreCase("null")) {
                    return new Neo4jValue(null, neoType);
                }
                throw new IllegalArgumentException(String.format("A %s can only have a `defaultValue = \"null\"", javaType.getSimpleName()));
            };
        }
    }

    static interface NeoValueConverter {
        public Neo4jTypes.AnyType type();

        public Object toNeoValue(Object var1) throws ProcedureException;

        public Optional<Neo4jValue> defaultValue(Name var1) throws ProcedureException;
    }
}

