/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;

public class AwaitIndexProcedure {
    private final ReadOperations operations;

    public AwaitIndexProcedure(KernelTransaction tx) {
        this.operations = tx.acquireStatement().readOperations();
    }

    public void execute(String labelName, String propertyKeyName, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        int labelId = this.getLabelId(labelName);
        int propertyKeyId = this.getPropertyKeyId(propertyKeyName);
        String indexDescription = this.formatIndex(labelName, propertyKeyName);
        IndexDescriptor index = this.getIndex(labelId, propertyKeyId, indexDescription);
        this.waitUntilOnline(index, indexDescription, timeout, timeoutUnits);
    }

    private int getLabelId(String labelName) throws ProcedureException {
        int labelId = this.operations.labelGetForName(labelName);
        if (labelId == -1) {
            throw new ProcedureException((Status)Status.Schema.LabelAccessFailed, "No such label %s", labelName);
        }
        return labelId;
    }

    private int getPropertyKeyId(String propertyKeyName) throws ProcedureException {
        int propertyKeyId = this.operations.propertyKeyGetForName(propertyKeyName);
        if (propertyKeyId == -1) {
            throw new ProcedureException((Status)Status.Schema.PropertyKeyAccessFailed, "No such property key %s", propertyKeyName);
        }
        return propertyKeyId;
    }

    private IndexDescriptor getIndex(int labelId, int propertyKeyId, String indexDescription) throws ProcedureException {
        try {
            return this.operations.indexGetForLabelAndPropertyKey(labelId, propertyKeyId);
        }
        catch (SchemaRuleNotFoundException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on %s", indexDescription);
        }
    }

    private void waitUntilOnline(IndexDescriptor index, String indexDescription, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(indexDescription, index), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on %s did not come online within %s %s", new Object[]{indexDescription, timeout, timeoutUnits});
        }
        catch (InterruptedException e) {
            throw new ProcedureException((Status)Status.General.DatabaseUnavailable, "Interrupted waiting for index on %s to come online", indexDescription);
        }
    }

    private boolean isOnline(String indexDescription, IndexDescriptor index) throws ProcedureException {
        InternalIndexState state = this.getState(indexDescription, index);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, "Index on %s is in failed state", indexDescription);
            }
        }
        throw new IllegalStateException("Unknown index state " + (Object)((Object)state));
    }

    private InternalIndexState getState(String indexDescription, IndexDescriptor index) throws ProcedureException {
        try {
            return this.operations.indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on %s", indexDescription);
        }
    }

    private String formatIndex(String labelName, String propertyKeyName) {
        return String.format(":%s(%s)", labelName, propertyKeyName);
    }
}

