/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;

public class LogPruneStrategyFactory {
    public static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public void prune(long upToLogVersion) {
        }

        public String toString() {
            return "NO_PRUNING";
        }
    };

    public static LogPruneStrategy fromConfigValue(FileSystemAbstraction fileSystem, LogFileInformation logFileInformation, PhysicalLogFiles files, String configValue) {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse(configValue);
        if (value == ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING) {
            return NO_PRUNING;
        }
        Threshold thresholdToUse = LogPruneStrategyFactory.getThresholdByType(fileSystem, value, configValue);
        return new ThresholdBasedPruneStrategy(fileSystem, logFileInformation, files, thresholdToUse);
    }

    static Threshold getThresholdByType(FileSystemAbstraction fileSystem, ThresholdConfigParser.ThresholdConfigValue value, String originalConfigValue) {
        long thresholdValue = value.value;
        switch (value.type) {
            case "files": {
                return new FileCountThreshold(thresholdValue);
            }
            case "size": {
                return new FileSizeThreshold(fileSystem, thresholdValue);
            }
            case "txs": 
            case "entries": {
                return new EntryCountThreshold(thresholdValue);
            }
            case "hours": {
                return new EntryTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.HOURS, thresholdValue);
            }
            case "days": {
                return new EntryTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.DAYS, thresholdValue);
            }
        }
        throw new IllegalArgumentException("Invalid log pruning configuration value '" + originalConfigValue + "'. Invalid type '" + value.type + "', valid are files, size, txs, entries, hours, days.");
    }
}

