/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

public class GuardingStatementOperations
implements EntityWriteOperations,
EntityReadOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final EntityReadOperations entityReadDelegate;
    private final Guard guard;

    public GuardingStatementOperations(EntityWriteOperations entityWriteDelegate, EntityReadOperations entityReadDelegate, Guard guard) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.entityReadDelegate = entityReadDelegate;
        this.guard = guard;
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        this.guard.check();
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, KernelException {
        this.guard.check();
        return this.entityWriteDelegate.nodeDetachDelete(state, nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        this.guard.check();
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.guard.check();
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        this.guard.check();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        this.guard.check();
        return this.entityReadDelegate.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexSeek(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(KernelStatement state, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByNumber(state, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement state, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByString(state, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexRangeSeekByPrefix(state, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexScan(state, index);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexContainsScan(KernelStatement state, IndexDescriptor index, String term) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexContainsScan(state, index, term);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexEndsWithScan(KernelStatement state, IndexDescriptor index, String suffix) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesGetFromIndexEndsWithScan(state, index, suffix);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeGetFromUniqueIndexSeek(state, index, value);
    }

    @Override
    public long nodesCountIndexed(KernelStatement statement, IndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodesCountIndexed(statement, index, nodeId, value);
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        this.guard.check();
        return this.entityReadDelegate.graphHasProperty(state, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement state, int propertyKeyId) {
        this.guard.check();
        return this.entityReadDelegate.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.graphGetPropertyKeys(state);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.nodesGetAll(state);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        this.guard.check();
        return this.entityReadDelegate.relationshipsGetAll(state);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.guard.check();
        this.entityReadDelegate.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<NodeItem> nodeCursor(KernelStatement statement, long nodeId) {
        this.guard.check();
        return this.entityReadDelegate.nodeCursor(statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        this.guard.check();
        return this.entityReadDelegate.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursor(KernelStatement statement, long relId) {
        this.guard.check();
        return this.entityReadDelegate.relationshipCursor(statement, relId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetAll(KernelStatement statement) {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetAll(statement);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        this.guard.check();
        return this.entityReadDelegate.relationshipCursorGetAll(statement);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetForLabel(KernelStatement statement, int labelId) {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetForLabel(statement, labelId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexSeek(statement, index, value);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexScan(KernelStatement statement, IndexDescriptor index) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexScan(statement, index);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByNumber(KernelStatement statement, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexRangeSeekByNumber(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByString(KernelStatement statement, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexRangeSeekByString(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexSeekByPrefix(statement, index, prefix);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromIndexRangeSeekByPrefix(statement, index, prefix);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromUniqueIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.guard.check();
        return this.entityReadDelegate.nodeCursorGetFromUniqueIndexSeek(statement, index, value);
    }

    @Override
    public long nodesGetCount(KernelStatement statement) {
        this.guard.check();
        return this.entityReadDelegate.nodesGetCount(statement);
    }

    @Override
    public long relationshipsGetCount(KernelStatement statement) {
        this.guard.check();
        return this.entityReadDelegate.relationshipsGetCount(statement);
    }

    @Override
    public boolean nodeExists(KernelStatement statement, long id) {
        this.guard.check();
        return this.entityReadDelegate.nodeExists(statement, id);
    }
}

