/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public interface AuthToken {
    public static final String SCHEME_KEY = "scheme";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIALS = "credentials";
    public static final String NEW_CREDENTIALS = "new_credentials";

    public static String safeCast(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null || !(value instanceof String)) {
            throw new InvalidAuthTokenException("The value associated with the key `" + key + "` must be a String but was: " + (value == null ? "null" : value.getClass().getSimpleName()));
        }
        return (String)value;
    }

    public static Map<String, Object> newBasicAuthToken(String username, String password) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, "basic", PRINCIPAL, username, CREDENTIALS, password});
    }
}

