/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.io.IOException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;

public interface AuthSubject
extends AccessMode {
    public static final AuthSubject ANONYMOUS = new AuthSubject(){

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.FAILURE;
        }

        @Override
        public void setPassword(String password) throws IOException, InvalidArgumentsException {
            throw new AuthorizationViolationException("Anonymous cannot change password");
        }

        @Override
        public boolean allowsReads() {
            return false;
        }

        @Override
        public boolean allowsWrites() {
            return false;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return false;
        }

        @Override
        public boolean overrideOriginalMode() {
            return false;
        }

        @Override
        public String name() {
            return "<anonymous>";
        }
    };
    public static final AuthSubject AUTH_DISABLED = new AuthSubject(){

        @Override
        public boolean allowsReads() {
            return true;
        }

        @Override
        public boolean allowsWrites() {
            return true;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return true;
        }

        @Override
        public boolean overrideOriginalMode() {
            return false;
        }

        @Override
        public String name() {
            return "<auth disabled>";
        }

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.SUCCESS;
        }

        @Override
        public void setPassword(String password) throws IOException, InvalidArgumentsException {
        }
    };

    public void logout();

    public AuthenticationResult getAuthenticationResult();

    public void setPassword(String var1) throws IOException, InvalidArgumentsException;
}

