/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class DeleteDuplicateNodesStep
extends LonelyProcessingStep {
    private final NodeStore nodeStore;
    private final PrimitiveLongIterator nodeIds;
    private final LabelScanWriter labelScanWriter;

    public DeleteDuplicateNodesStep(StageControl control, Configuration config, PrimitiveLongIterator nodeIds, NodeStore nodeStore, LabelScanStore labelScanStore) {
        super(control, "DEDUP", config, new StatsProvider[0]);
        this.nodeStore = nodeStore;
        this.nodeIds = nodeIds;
        this.labelScanWriter = labelScanStore.newWriter();
    }

    @Override
    protected void process() throws IOException {
        NodeRecord record = (NodeRecord)this.nodeStore.newRecord();
        while (this.nodeIds.hasNext()) {
            long duplicateNodeId = this.nodeIds.next();
            record.setId(duplicateNodeId);
            this.nodeStore.updateRecord(record);
            this.labelScanWriter.write(NodeLabelUpdate.labelChanges(duplicateNodeId, PrimitiveLongCollections.EMPTY_LONG_ARRAY, PrimitiveLongCollections.EMPTY_LONG_ARRAY));
        }
    }

    @Override
    public void close() throws Exception {
        this.labelScanWriter.close();
        super.close();
    }
}

