/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.id.IdType;

public enum StoreType {
    NODE_LABEL(".nodestore.db.labels"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicArrayStore(this.getStoreName(), IdType.NODE_LABELS, GraphDatabaseSettings.label_block_size);
        }
    }
    ,
    NODE(".nodestore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeStore(this.getStoreName());
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME(".propertystore.db.index.keys"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.PROPERTY_KEY_TOKEN_NAME, 30);
        }
    }
    ,
    PROPERTY_KEY_TOKEN(".propertystore.db.index"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenStore(this.getStoreName());
        }
    }
    ,
    PROPERTY_STRING(".propertystore.db.strings"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.STRING_BLOCK, GraphDatabaseSettings.string_block_size);
        }
    }
    ,
    PROPERTY_ARRAY(".propertystore.db.arrays"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicArrayStore(this.getStoreName(), IdType.ARRAY_BLOCK, GraphDatabaseSettings.array_block_size);
        }
    }
    ,
    PROPERTY(".propertystore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP(".relationshipstore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME(".relationshiptypestore.db.names"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.RELATIONSHIP_TYPE_TOKEN_NAME, 30);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN(".relationshiptypestore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenStore(this.getStoreName());
        }
    }
    ,
    LABEL_TOKEN_NAME(".labeltokenstore.db.names"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createDynamicStringStore(this.getStoreName(), IdType.LABEL_TOKEN_NAME, 30);
        }
    }
    ,
    LABEL_TOKEN(".labeltokenstore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenStore(this.getStoreName());
        }
    }
    ,
    SCHEMA(".schemastore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createSchemaStore(this.getStoreName());
        }
    }
    ,
    RELATIONSHIP_GROUP(".relationshipgroupstore.db"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipGroupStore(this.getStoreName());
        }
    }
    ,
    COUNTS(".counts.db", false){

        @Override
        public CountsTracker open(NeoStores neoStores) {
            return neoStores.createCountStore(this.getStoreName());
        }

        @Override
        void close(NeoStores me, Object object) {
            try {
                ((CountsTracker)object).shutdown();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }
    ,
    META_DATA("neostore"){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createMetadataStore();
        }
    };

    private final boolean recordStore;
    private final String storeName;

    private StoreType(String storeName) {
        this(storeName, true);
    }

    private StoreType(String storeName, boolean recordStore) {
        this.storeName = storeName;
        this.recordStore = recordStore;
    }

    abstract Object open(NeoStores var1);

    public boolean isRecordStore() {
        return this.recordStore;
    }

    public String getStoreName() {
        return this.storeName;
    }

    void close(NeoStores me, Object object) {
        ((CommonAbstractStore)object).close();
    }

    public static StoreType typeOf(String storeFileName) {
        StoreType[] values;
        for (StoreType value : values = StoreType.values()) {
            if (!storeFileName.equals("neostore" + value.getStoreName())) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum constant for " + storeFileName + " file.");
    }
}

