/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class NodePropertyUniqueConstraintCreator
extends BaseNodeConstraintCreator {
    protected final String propertyKey;

    NodePropertyUniqueConstraintCreator(InternalSchemaActions internalCreator, Label label, String propertyKey) {
        super(internalCreator, label);
        this.propertyKey = propertyKey;
    }

    @Override
    public final NodePropertyUniqueConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one unique constraint at a time.");
    }

    @Override
    public final ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        try {
            return this.actions.createPropertyUniquenessConstraint(this.label, this.propertyKey);
        }
        catch (KernelException e) {
            String userMessage = this.actions.getUserMessage(e);
            throw new ConstraintViolationException(userMessage, (Throwable)e);
        }
    }
}

