/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipTypeCheckerStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private static final Comparator<Map.Entry<Object, AtomicLong>> SORT_BY_COUNT_DESC = (e1, e2) -> Long.compare(((AtomicLong)e2.getValue()).get(), ((AtomicLong)e1.getValue()).get());
    private static final Comparator<Map.Entry<Object, AtomicLong>> SORT_BY_ID_DESC = (e1, e2) -> Integer.compare((Integer)e2.getKey(), (Integer)e1.getKey());
    private final ConcurrentMap<Object, AtomicLong> allTypes = new ConcurrentHashMap<Object, AtomicLong>();
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository typeTokenRepository;
    private Map.Entry<Object, AtomicLong>[] sortedTypes;

    public RelationshipTypeCheckerStep(StageControl control, Configuration config, BatchingTokenRepository.BatchingRelationshipTypeTokenRepository typeTokenRepository) {
        super(control, "TYPE", config, 0, new StatsProvider[0]);
        this.typeTokenRepository = typeTokenRepository;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        for (InputRelationship relationship : (InputRelationship[])batch.input) {
            Object type = relationship.typeAsObject();
            AtomicLong count = (AtomicLong)this.allTypes.get(type);
            if (count == null) {
                count = new AtomicLong();
                AtomicLong existing = this.allTypes.putIfAbsent(type, count);
                count = existing != null ? existing : count;
            }
            count.incrementAndGet();
        }
        sender.send(batch);
    }

    @Override
    protected void done() {
        this.sortedTypes = this.allTypes.entrySet().toArray(new Map.Entry[this.allTypes.size()]);
        if (this.sortedTypes.length > 0) {
            Comparator<Map.Entry<Object, AtomicLong>> comparator = this.sortedTypes[0].getKey() instanceof Integer ? SORT_BY_ID_DESC : SORT_BY_COUNT_DESC;
            Arrays.sort(this.sortedTypes, comparator);
        }
        for (int i = this.sortedTypes.length - 1; i >= 0; --i) {
            this.typeTokenRepository.getOrCreateId(this.sortedTypes[i].getKey());
        }
        super.done();
    }

    public Object[] getRelationshipTypes(long belowOrEqualToThreshold) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, AtomicLong> candidate : this.sortedTypes) {
            if (candidate.getValue().get() > belowOrEqualToThreshold) continue;
            result.add(candidate.getKey());
        }
        return result.toArray();
    }
}

