/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RecordIdIteration;
import org.neo4j.unsafe.impl.batchimport.RecordProcessorStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackProcessor;
import org.neo4j.unsafe.impl.batchimport.UpdateRecordsStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class RelationshipLinkbackStage
extends Stage {
    public RelationshipLinkbackStage(String topic, Configuration config, RelationshipStore store, NodeRelationshipCache cache, long lowRelationshipId, long highRelationshipId, boolean denseNodes) {
        super("Relationship --> Relationship" + topic, config);
        this.add(new ReadRecordsStep<RelationshipRecord>(this.control(), config, store, RecordIdIteration.backwards(highRelationshipId, lowRelationshipId)));
        this.add(new RecordProcessorStep<RelationshipRecord>(this.control(), "LINK", config, new RelationshipLinkbackProcessor(cache, denseNodes), false, new StatsProvider[0]));
        this.add(new UpdateRecordsStep<RelationshipRecord>(this.control(), config, store));
    }
}

