/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public interface InputIterator<T>
extends ResourceIterator<T>,
SourceTraceability {

    public static class Empty<T>
    extends Adapter<T> {
        protected T fetchNextOrNull() {
            return null;
        }
    }

    public static class Delegate<T>
    extends PrefetchingIterator<T>
    implements InputIterator<T> {
        protected final InputIterator<T> actual;

        public Delegate(InputIterator<T> actual) {
            this.actual = actual;
        }

        public void close() {
            this.actual.close();
        }

        protected T fetchNextOrNull() {
            return (T)(this.actual.hasNext() ? this.actual.next() : null);
        }

        public String sourceDescription() {
            return this.actual.sourceDescription();
        }

        public long lineNumber() {
            return this.actual.lineNumber();
        }

        public long position() {
            return this.actual.position();
        }
    }

    public static abstract class Adapter<T>
    extends PrefetchingIterator<T>
    implements InputIterator<T> {
        private final SourceTraceability defaults = new SourceTraceability.Adapter(){

            public String sourceDescription() {
                return Readables.EMPTY.sourceDescription();
            }
        };

        public String sourceDescription() {
            return this.defaults.sourceDescription();
        }

        public long lineNumber() {
            return this.defaults.lineNumber();
        }

        public long position() {
            return this.defaults.position();
        }

        public void close() {
        }
    }
}

