/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.helpers.collection.CloseableVisitor;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.state.RecoverableTransaction;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class RecoveryVisitor
implements CloseableVisitor<RecoverableTransaction, Exception> {
    private final TransactionIdStore store;
    private final StorageEngine storageEngine;
    private final Monitor monitor;
    private long lastTransactionIdApplied = -1L;
    private long lastTransactionChecksum;
    private LogPosition lastTransactionLogPosition;
    private final TransactionQueue queue = new TransactionQueue(10000, this::applyQueue);

    public RecoveryVisitor(TransactionIdStore store, StorageEngine storageEngine, Monitor monitor) {
        this.store = store;
        this.storageEngine = storageEngine;
        this.monitor = monitor;
    }

    public boolean visit(RecoverableTransaction transaction) throws Exception {
        CommittedTransactionRepresentation representation = transaction.representation();
        long txId = representation.getCommitEntry().getTxId();
        TransactionRepresentation txRepresentation = representation.getTransactionRepresentation();
        this.queue(txRepresentation, txId);
        this.lastTransactionIdApplied = txId;
        this.lastTransactionChecksum = LogEntryStart.checksum(representation.getStartEntry());
        this.lastTransactionLogPosition = transaction.positionAfterTx();
        this.monitor.transactionRecovered(txId);
        return false;
    }

    private void queue(TransactionRepresentation txRepresentation, long txId) throws Exception {
        TransactionToApply tx = new TransactionToApply(txRepresentation, txId);
        tx.commitment(Commitment.NO_COMMITMENT, txId);
        this.queue.queue(tx);
    }

    private void applyQueue(TransactionToApply batch) throws Exception {
        this.storageEngine.apply(batch, TransactionApplicationMode.RECOVERY);
    }

    public void close() throws Exception {
        this.queue.empty();
        if (this.lastTransactionIdApplied != -1L) {
            this.store.setLastCommittedAndClosedTransactionId(this.lastTransactionIdApplied, this.lastTransactionChecksum, this.lastTransactionLogPosition.getLogVersion(), this.lastTransactionLogPosition.getByteOffset());
        }
    }

    public static interface Monitor {
        public void transactionRecovered(long var1);
    }
}

