/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.store.record.RecordSerializable;

public class RecordSerializer {
    private final List<RecordSerializable> serializables = new ArrayList<RecordSerializable>();

    public RecordSerializer append(RecordSerializable serializable) {
        this.serializables.add(serializable);
        return this;
    }

    public byte[] serialize() {
        int[] lengths = new int[this.serializables.size()];
        int totalLength = 0;
        for (int i = 0; i < this.serializables.size(); ++i) {
            lengths[i] = this.serializables.get(i).length();
            totalLength += lengths[i];
        }
        byte[] array = new byte[totalLength];
        ByteBuffer target = ByteBuffer.wrap(array);
        for (int i = 0; i < this.serializables.size(); ++i) {
            this.serializables.get(i).serialize(target);
        }
        return array;
    }
}

