/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeLabelsField {
    public static NodeLabels parseLabelsField(NodeRecord node) {
        long labelField = node.getLabelField();
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField) ? new DynamicNodeLabels(node) : new InlineNodeLabels(node);
    }

    public static long[] get(NodeRecord node, NodeStore nodeStore) {
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField()) ? DynamicNodeLabels.get(node, nodeStore) : InlineNodeLabels.get(node);
    }

    public static long[] get(NodeRecord node, RecordCursor<DynamicRecord> dynamicLabelCursor) {
        return NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField()) ? DynamicNodeLabels.get(node, dynamicLabelCursor) : InlineNodeLabels.get(node);
    }

    public static boolean fieldPointsToDynamicRecordOfLabels(long labelField) {
        return (labelField & 0x8000000000L) != 0L;
    }

    public static long parseLabelsBody(long labelField) {
        return labelField & 0xFFFFFFFFFL;
    }

    public static long firstDynamicLabelRecordId(long labelField) {
        assert (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField));
        return NodeLabelsField.parseLabelsBody(labelField);
    }

    public static boolean isSane(long[] labelIds) {
        long prev = -1L;
        for (long labelId : labelIds) {
            if (labelId <= prev) {
                return false;
            }
            prev = labelId;
        }
        return true;
    }
}

