/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;

public interface CallableProcedure {
    public ProcedureSignature signature();

    public RawIterator<Object[], ProcedureException> apply(Context var1, Object[] var2) throws ProcedureException;

    public static abstract class BasicProcedure
    implements CallableProcedure {
        private final ProcedureSignature signature;

        protected BasicProcedure(ProcedureSignature signature) {
            this.signature = signature;
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public abstract RawIterator<Object[], ProcedureException> apply(Context var1, Object[] var2) throws ProcedureException;
    }

    public static class BasicContext
    implements Context {
        private final Map<String, Object> values = new HashMap<String, Object>();

        @Override
        public <T> T get(Key<T> key) throws ProcedureException {
            Object o = this.values.get(key.name());
            if (o == null) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", key.name());
            }
            return (T)o;
        }

        public <T> void put(Key<T> key, T value) {
            this.values.put(key.name(), value);
        }
    }

    public static interface Key<T> {
        public String name();

        public static <T> Key<T> key(String name, Class<T> type) {
            return () -> name;
        }
    }

    public static interface Context {
        public static final Key<KernelTransaction> KERNEL_TRANSACTION = Key.key("KernelTransaction", KernelTransaction.class);
        public static final Key<AccessMode> ACCESS_MODE = Key.key("AccessMode", AccessMode.class);
        public static final Key<AuthSubject> AUTH_SUBJECT = Key.key("AuthSubject", AuthSubject.class);
        public static final Key<Thread> THREAD = Key.key("Thread", Thread.class);

        public <T> T get(Key<T> var1) throws ProcedureException;
    }
}

