/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.Collections;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public abstract class EditionModule {
    public IdGeneratorFactory idGeneratorFactory;
    public LabelTokenHolder labelTokenHolder;
    public PropertyKeyTokenHolder propertyKeyTokenHolder;
    public Locks lockManager;
    public CommitProcessFactory commitProcessFactory;
    public long transactionStartTimeout;
    public RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    public TransactionHeaderInformationFactory headerInformationFactory;
    public SchemaWriteGuard schemaWriteGuard;
    public ConstraintSemantics constraintSemantics;
    public CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;
    public IOLimiter ioLimiter;
    public RecordFormats formats;

    public void registerProcedures(Procedures procedures) {
    }

    protected void doAfterRecoveryAndStartup(DatabaseInfo databaseInfo, DependencyResolver dependencyResolver) {
        DiagnosticsManager diagnosticsManager = (DiagnosticsManager)dependencyResolver.resolveDependency(DiagnosticsManager.class);
        NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class);
        diagnosticsManager.prependProvider(new KernelDiagnostics.Versions(databaseInfo, neoStoreDataSource.getStoreId()));
        neoStoreDataSource.registerDiagnosticsWith(diagnosticsManager);
        diagnosticsManager.appendProvider(new KernelDiagnostics.StoreFiles(neoStoreDataSource.getStoreDir()));
    }

    protected void publishEditionInfo(UsageData sysInfo, DatabaseInfo databaseInfo, Config config) {
        sysInfo.set(UsageDataKeys.edition, databaseInfo.edition);
        sysInfo.set(UsageDataKeys.operationalMode, databaseInfo.operationalMode);
        config.augment(Collections.singletonMap(GraphDatabaseFacadeFactory.Configuration.editionName.name(), databaseInfo.edition.toString()));
    }

    protected SPI spi() {
        return null;
    }

    public static AuthManager createAuthManager(Config config, LogService logging) {
        boolean authEnabled = config.get(GraphDatabaseSettings.auth_enabled);
        if (!authEnabled) {
            return AuthManager.NO_AUTH;
        }
        String key = config.get(GraphDatabaseSettings.auth_manager);
        for (AuthManager.Factory candidate : Service.load(AuthManager.Factory.class)) {
            String candidateId = candidate.getKeys().iterator().next();
            if (candidateId.equals(key)) {
                return candidate.newInstance(config, logging.getUserLogProvider());
            }
            if (!key.isEmpty()) continue;
            logging.getInternalLog(GraphDatabaseFacadeFactory.class).info("No auth manager implementation specified, defaulting to '" + candidateId + "'");
            return candidate.newInstance(config, logging.getUserLogProvider());
        }
        if (key.isEmpty()) {
            logging.getUserLog(GraphDatabaseFacadeFactory.class).error("No auth manager implementation specified and no default could be loaded. It is an illegal product configuration to have auth enabled and not provide an auth manager service.");
            throw new IllegalArgumentException("Auth enabled but no auth manager found. This is an illegal product configuration.");
        }
        throw new IllegalArgumentException("No auth manager found with the name '" + key + "'.");
    }

    public static interface SPI {
    }
}

