/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.Supplier;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter
implements Supplier<Statement> {
    private final ThreadLocal<KernelTransaction> threadToTransactionMap = new ThreadLocal();
    private boolean isShutdown;

    public boolean hasTransaction() {
        this.checkIfShutdown();
        return this.threadToTransactionMap.get() != null;
    }

    public void bindTransactionToCurrentThread(KernelTransaction transaction) {
        if (this.threadToTransactionMap.get() != null) {
            throw new IllegalStateException(Thread.currentThread() + " already has a transaction bound");
        }
        this.threadToTransactionMap.set(transaction);
    }

    public void unbindTransactionFromCurrentThread() {
        this.threadToTransactionMap.remove();
    }

    @Override
    public Statement get() {
        this.checkIfShutdown();
        return this.getKernelTransactionBoundToThisThread(true).acquireStatement();
    }

    private void assertInUnterminatedTransaction(KernelTransaction transaction) {
        if (transaction == null) {
            throw new BridgeNotInTransactionException();
        }
        if (transaction.shouldBeTerminated()) {
            throw new BridgeTransactionTerminatedException();
        }
    }

    public void assertInUnterminatedTransaction() {
        this.checkIfShutdown();
        this.assertInUnterminatedTransaction(this.threadToTransactionMap.get());
    }

    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new BridgeDatabaseShutdownException();
        }
    }

    public KernelTransaction getTopLevelTransactionBoundToThisThread(boolean strict) {
        KernelTransaction transaction = this.threadToTransactionMap.get();
        if (strict) {
            this.assertInUnterminatedTransaction(transaction);
        }
        return transaction;
    }

    public KernelTransaction getKernelTransactionBoundToThisThread(boolean strict) {
        this.checkIfShutdown();
        return this.getTopLevelTransactionBoundToThisThread(strict);
    }

    private static class BridgeDatabaseShutdownException
    extends DatabaseShutdownException
    implements Status.HasStatus {
        private BridgeDatabaseShutdownException() {
        }

        public Status status() {
            return Status.General.DatabaseUnavailable;
        }
    }

    private static class BridgeTransactionTerminatedException
    extends TransactionTerminatedException
    implements Status.HasStatus {
        private BridgeTransactionTerminatedException() {
        }

        public Status status() {
            return Status.Transaction.TransactionTerminated;
        }
    }

    private static class BridgeNotInTransactionException
    extends NotInTransactionException
    implements Status.HasStatus {
        private BridgeNotInTransactionException() {
        }

        public Status status() {
            return Status.Request.TransactionRequired;
        }
    }
}

