/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class ReadAheadChannel<T extends StoreChannel>
implements ReadableClosableChannel {
    public static final int DEFAULT_READ_AHEAD_SIZE = 4096;
    protected T channel;
    private final ByteBuffer aheadBuffer;
    private final int readAheadSize;

    public ReadAheadChannel(T channel) {
        this(channel, 4096);
    }

    public ReadAheadChannel(T channel, int readAheadSize) {
        this.aheadBuffer = ByteBuffer.allocate(readAheadSize);
        this.aheadBuffer.position(this.aheadBuffer.capacity());
        this.channel = channel;
        this.readAheadSize = readAheadSize;
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.aheadBuffer.get();
    }

    @Override
    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.aheadBuffer.getShort();
    }

    @Override
    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getInt();
    }

    @Override
    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getLong();
    }

    @Override
    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getFloat();
    }

    @Override
    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        int chunkSize;
        assert (length <= bytes.length);
        for (int bytesGotten = 0; bytesGotten < length; bytesGotten += chunkSize) {
            chunkSize = Math.min(this.readAheadSize >> 2, length - bytesGotten);
            this.ensureDataExists(chunkSize);
            this.aheadBuffer.get(bytes, bytesGotten, chunkSize);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        int remaining = this.aheadBuffer.remaining();
        if (remaining >= requestedNumberOfBytes) {
            return;
        }
        this.compactToBeginningOfBuffer(remaining);
        while (this.aheadBuffer.position() < this.aheadBuffer.capacity()) {
            int read = this.channel.read(this.aheadBuffer);
            if (read != -1) continue;
            if (this.aheadBuffer.position() >= requestedNumberOfBytes) break;
            T nextChannel = this.next(this.channel);
            assert (nextChannel != null);
            if (nextChannel == this.channel) {
                this.aheadBuffer.flip();
                throw ReadPastEndException.INSTANCE;
            }
            this.channel = nextChannel;
        }
        this.aheadBuffer.flip();
    }

    protected T next(T channel) throws IOException {
        return channel;
    }

    protected long offset() throws IOException {
        return this.channel.position() - (long)this.aheadBuffer.remaining();
    }

    private void compactToBeginningOfBuffer(int remaining) {
        System.arraycopy(this.aheadBuffer.array(), this.aheadBuffer.position(), this.aheadBuffer.array(), 0, remaining);
        this.aheadBuffer.clear();
        this.aheadBuffer.position(remaining);
    }
}

