/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.kernel.impl.api.store.StoreAbstractNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class StoreSingleNodeCursor
extends StoreAbstractNodeCursor {
    private long nodeId;
    private final Consumer<StoreSingleNodeCursor> instanceCache;

    public StoreSingleNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, StoreStatement storeStatement, Consumer<StoreSingleNodeCursor> instanceCache, LockService lockService) {
        super(nodeRecord, neoStores, storeStatement, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreSingleNodeCursor init(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public boolean next() {
        if (this.nodeId != -1L) {
            try {
                boolean bl = this.nodeStore.getRecord(this.nodeId, this.nodeRecord, RecordLoad.CHECK).inUse();
                return bl;
            }
            finally {
                this.nodeId = -1L;
            }
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

