/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.storageengine.api.Direction;

public class RelationshipChangesForNode {
    private final DiffStrategy diffStrategy;
    private final RelationshipVisitor.Home relationshipHome;
    private Map<Integer, Set<Long>> outgoing;
    private Map<Integer, Set<Long>> incoming;
    private Map<Integer, Set<Long>> loops;
    private int totalOutgoing = 0;
    private int totalIncoming = 0;
    private int totalLoops = 0;
    private static final Function<Map<Integer, Set<Long>>, Iterator<Set<Long>>> ALL_TYPES = integerSetMap -> integerSetMap.values().iterator();

    public RelationshipChangesForNode(DiffStrategy diffStrategy, RelationshipVisitor.Home relationshipHome) {
        this.diffStrategy = diffStrategy;
        this.relationshipHome = relationshipHome;
    }

    public void addRelationship(long relId, int typeId, Direction direction) {
        Map<Integer, Set<Long>> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        Set<Long> rels = relTypeToRelsMap.get(typeId);
        if (rels == null) {
            rels = Collections.newSetFromMap(new VersionedHashMap());
            relTypeToRelsMap.put(typeId, rels);
        }
        rels.add(relId);
        switch (direction) {
            case INCOMING: {
                ++this.totalIncoming;
                break;
            }
            case OUTGOING: {
                ++this.totalOutgoing;
                break;
            }
            case BOTH: {
                ++this.totalLoops;
            }
        }
    }

    public boolean removeRelationship(long relId, int typeId, Direction direction) {
        Map<Integer, Set<Long>> relTypeToRelsMap = this.getTypeToRelMapForDirection(direction);
        Set<Long> rels = relTypeToRelsMap.get(typeId);
        if (rels != null && rels.remove(relId)) {
            if (rels.isEmpty()) {
                relTypeToRelsMap.remove(typeId);
            }
            switch (direction) {
                case INCOMING: {
                    --this.totalIncoming;
                    break;
                }
                case OUTGOING: {
                    --this.totalOutgoing;
                    break;
                }
                case BOTH: {
                    --this.totalLoops;
                }
            }
            return true;
        }
        return false;
    }

    public RelationshipIterator augmentRelationships(Direction direction, RelationshipIterator rels) {
        return this.augmentRelationships(direction, rels, ALL_TYPES);
    }

    public RelationshipIterator augmentRelationships(Direction direction, int[] types, RelationshipIterator rels) {
        return this.augmentRelationships(direction, rels, this.typeFilter(types));
    }

    public RelationshipIterator augmentRelationships(Direction direction, RelationshipIterator rels, Function<Map<Integer, Set<Long>>, Iterator<Set<Long>>> typeFilter) {
        switch (direction) {
            case INCOMING: {
                if (this.incoming == null || this.incoming.isEmpty()) break;
                rels = this.diffStrategy.augmentPrimitiveIterator(rels, typeFilter.apply(this.incoming), this.relationshipHome);
                break;
            }
            case OUTGOING: {
                if (this.outgoing == null || this.outgoing.isEmpty()) break;
                rels = this.diffStrategy.augmentPrimitiveIterator(rels, typeFilter.apply(this.outgoing), this.relationshipHome);
                break;
            }
            case BOTH: {
                if (this.outgoing != null && !this.outgoing.isEmpty()) {
                    rels = this.diffStrategy.augmentPrimitiveIterator(rels, typeFilter.apply(this.outgoing), this.relationshipHome);
                }
                if (this.incoming == null || this.incoming.isEmpty()) break;
                rels = this.diffStrategy.augmentPrimitiveIterator(rels, typeFilter.apply(this.incoming), this.relationshipHome);
            }
        }
        if (this.loops != null && !this.loops.isEmpty()) {
            rels = this.diffStrategy.augmentPrimitiveIterator(rels, typeFilter.apply(this.loops), this.relationshipHome);
        }
        return rels;
    }

    public int augmentDegree(Direction direction, int degree) {
        switch (direction) {
            case INCOMING: {
                return this.diffStrategy.augmentDegree(degree, this.totalIncoming + this.totalLoops);
            }
            case OUTGOING: {
                return this.diffStrategy.augmentDegree(degree, this.totalOutgoing + this.totalLoops);
            }
        }
        return this.diffStrategy.augmentDegree(degree, this.totalIncoming + this.totalOutgoing + this.totalLoops);
    }

    public int augmentDegree(Direction direction, int degree, int typeId) {
        switch (direction) {
            case INCOMING: {
                if (this.incoming == null || !this.incoming.containsKey(typeId)) break;
                degree = this.diffStrategy.augmentDegree(degree, this.incoming.get(typeId).size());
                break;
            }
            case OUTGOING: {
                if (this.outgoing == null || !this.outgoing.containsKey(typeId)) break;
                degree = this.diffStrategy.augmentDegree(degree, this.outgoing.get(typeId).size());
                break;
            }
            case BOTH: {
                if (this.outgoing != null && this.outgoing.containsKey(typeId)) {
                    degree = this.diffStrategy.augmentDegree(degree, this.outgoing.get(typeId).size());
                }
                if (this.incoming == null || !this.incoming.containsKey(typeId)) break;
                degree = this.diffStrategy.augmentDegree(degree, this.incoming.get(typeId).size());
            }
        }
        if (this.loops != null && this.loops.containsKey(typeId)) {
            degree = this.diffStrategy.augmentDegree(degree, this.loops.get(typeId).size());
        }
        return degree;
    }

    public PrimitiveIntIterator relationshipTypes() {
        HashSet<Integer> types = new HashSet<Integer>();
        if (this.outgoing != null && !this.outgoing.isEmpty()) {
            types.addAll(this.outgoing.keySet());
        }
        if (this.incoming != null && !this.incoming.isEmpty()) {
            types.addAll(this.incoming.keySet());
        }
        if (this.loops != null && !this.loops.isEmpty()) {
            types.addAll(this.loops.keySet());
        }
        return PrimitiveIntCollections.toPrimitiveIterator(types.iterator());
    }

    public void clear() {
        if (this.outgoing != null) {
            this.outgoing.clear();
        }
        if (this.incoming != null) {
            this.incoming.clear();
        }
        if (this.loops != null) {
            this.loops.clear();
        }
    }

    private Map<Integer, Set<Long>> outgoing() {
        if (this.outgoing == null) {
            this.outgoing = new VersionedHashMap<Integer, Set<Long>>();
        }
        return this.outgoing;
    }

    private Map<Integer, Set<Long>> incoming() {
        if (this.incoming == null) {
            this.incoming = new VersionedHashMap<Integer, Set<Long>>();
        }
        return this.incoming;
    }

    private Map<Integer, Set<Long>> loops() {
        if (this.loops == null) {
            this.loops = new VersionedHashMap<Integer, Set<Long>>();
        }
        return this.loops;
    }

    private Map<Integer, Set<Long>> getTypeToRelMapForDirection(Direction direction) {
        Map<Integer, Set<Long>> relTypeToRelsMap = null;
        switch (direction) {
            case INCOMING: {
                relTypeToRelsMap = this.incoming();
                break;
            }
            case OUTGOING: {
                relTypeToRelsMap = this.outgoing();
                break;
            }
            case BOTH: {
                relTypeToRelsMap = this.loops();
            }
        }
        return relTypeToRelsMap;
    }

    private Function<Map<Integer, Set<Long>>, Iterator<Set<Long>>> typeFilter(final int[] types) {
        return relationshipsByType -> new PrefetchingIterator<Set<Long>>(){
            private final PrimitiveIntIterator iterTypes;
            {
                this.iterTypes = PrimitiveIntCollections.iterator((int[])types);
            }

            protected Set<Long> fetchNextOrNull() {
                while (this.iterTypes.hasNext()) {
                    Set relsByType = (Set)relationshipsByType.get(this.iterTypes.next());
                    if (relsByType == null) continue;
                    return relsByType;
                }
                return null;
            }
        };
    }

    private Iterator<Set<Long>> diffs(Function<Map<Integer, Set<Long>>, Iterator<Set<Long>>> filter, Map<Integer, Set<Long>> ... maps) {
        ArrayList<Set<Long>> result = new ArrayList<Set<Long>>();
        for (int i = 0; i < maps.length; ++i) {
            Map<Integer, Set<Long>> map = maps[i];
            if (map == null) continue;
            Iterator<Set<Long>> diffSet = filter.apply(map);
            while (diffSet.hasNext()) {
                result.add(diffSet.next());
            }
        }
        return result.iterator();
    }

    public PrimitiveLongIterator getRelationships(Direction direction) {
        return this.getRelationships(direction, ALL_TYPES);
    }

    public PrimitiveLongIterator getRelationships(Direction direction, int[] types) {
        return this.getRelationships(direction, this.typeFilter(types));
    }

    private PrimitiveLongIterator getRelationships(Direction direction, Function<Map<Integer, Set<Long>>, Iterator<Set<Long>>> types) {
        switch (direction) {
            case INCOMING: {
                return this.incoming != null || this.loops != null ? this.diffStrategy.getPrimitiveIterator(this.diffs(types, this.incoming, this.loops), this.relationshipHome) : PrimitiveLongCollections.emptyIterator();
            }
            case OUTGOING: {
                return this.outgoing != null || this.loops != null ? this.diffStrategy.getPrimitiveIterator(this.diffs(types, this.outgoing, this.loops), this.relationshipHome) : PrimitiveLongCollections.emptyIterator();
            }
            case BOTH: {
                return this.outgoing != null || this.incoming != null || this.loops != null ? this.diffStrategy.getPrimitiveIterator(this.diffs(types, this.outgoing, this.incoming, this.loops), this.relationshipHome) : PrimitiveLongCollections.emptyIterator();
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    public static enum DiffStrategy {
        REMOVE{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree - diff;
            }

            @Override
            RelationshipIterator augmentPrimitiveIterator(RelationshipIterator original, Iterator<Set<Long>> diff, RelationshipVisitor.Home txStateRelationshipHome) {
                throw new UnsupportedOperationException();
            }

            @Override
            PrimitiveLongIterator getPrimitiveIterator(Iterator<Set<Long>> diff, RelationshipVisitor.Home txStateRelationshipHome) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        ADD{

            @Override
            int augmentDegree(int degree, int diff) {
                return degree + diff;
            }

            @Override
            RelationshipIterator augmentPrimitiveIterator(final RelationshipIterator original, final Iterator<Set<Long>> diff, final RelationshipVisitor.Home txStateRelationshipHome) {
                if (!diff.hasNext()) {
                    return original;
                }
                return new RelationshipIterator(){
                    private Iterator<Long> currentSetOfAddedRels;

                    public boolean hasNext() {
                        return original.hasNext() || this.currentSetOfAddedRels().hasNext();
                    }

                    private Iterator<Long> currentSetOfAddedRels() {
                        while (diff.hasNext() && (this.currentSetOfAddedRels == null || !this.currentSetOfAddedRels.hasNext())) {
                            this.currentSetOfAddedRels = ((Set)diff.next()).iterator();
                        }
                        return this.currentSetOfAddedRels;
                    }

                    public long next() {
                        return original.hasNext() ? original.next() : this.currentSetOfAddedRels().next().longValue();
                    }

                    @Override
                    public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
                        RelationshipVisitor.Home home = this.currentSetOfAddedRels != null ? txStateRelationshipHome : original;
                        return home.relationshipVisit(relationshipId, visitor);
                    }
                };
            }

            @Override
            PrimitiveLongIterator getPrimitiveIterator(final Iterator<Set<Long>> diff, RelationshipVisitor.Home txStateRelationshipHome) {
                if (!diff.hasNext()) {
                    return PrimitiveLongCollections.emptyIterator();
                }
                return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
                    private Iterator<Long> currentSetOfAddedRels;

                    protected boolean fetchNext() {
                        Iterator<Long> iterator = this.currentSetOfAddedRels();
                        return iterator.hasNext() ? this.next(iterator.next()) : false;
                    }

                    private Iterator<Long> currentSetOfAddedRels() {
                        while (diff.hasNext() && (this.currentSetOfAddedRels == null || !this.currentSetOfAddedRels.hasNext())) {
                            this.currentSetOfAddedRels = ((Set)diff.next()).iterator();
                        }
                        return this.currentSetOfAddedRels;
                    }
                };
            }
        };


        abstract int augmentDegree(int var1, int var2);

        abstract RelationshipIterator augmentPrimitiveIterator(RelationshipIterator var1, Iterator<Set<Long>> var2, RelationshipVisitor.Home var3);

        abstract PrimitiveLongIterator getPrimitiveIterator(Iterator<Set<Long>> var1, RelationshipVisitor.Home var2);
    }
}

