/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.neo4j.collection.pool.LinkedQueuePool;
import org.neo4j.collection.pool.MarshlandPool;
import org.neo4j.collection.pool.Pool;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.CachingLegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.LegacyIndexTransactionStateImpl;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.storageengine.api.StorageEngine;

public class KernelTransactions
extends LifecycleAdapter {
    private final Locks locks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts statementOperations;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final TransactionCommitProcess transactionCommitProcess;
    private final TransactionHooks hooks;
    private final TransactionMonitor transactionMonitor;
    private final LifeSupport dataSourceLife;
    private final Tracers tracers;
    private final StorageEngine storageEngine;
    private final Procedures procedures;
    private final TransactionIdStore transactionIdStore;
    private final Supplier<LegacyIndexTransactionState> legacyIndexTxStateSupplier;
    private final Set<KernelTransactionImplementation> allTransactions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Factory<KernelTransactionImplementation> factory = new Factory<KernelTransactionImplementation>(){

        public KernelTransactionImplementation newInstance() {
            KernelTransactionImplementation tx = new KernelTransactionImplementation(KernelTransactions.this.statementOperations, KernelTransactions.this.schemaWriteGuard, KernelTransactions.this.hooks, KernelTransactions.this.constraintIndexCreator, KernelTransactions.this.procedures, KernelTransactions.this.transactionHeaderInformationFactory, KernelTransactions.this.transactionCommitProcess, KernelTransactions.this.transactionMonitor, KernelTransactions.this.legacyIndexTxStateSupplier, (Pool<KernelTransactionImplementation>)KernelTransactions.this.localTxPool, Clock.SYSTEM_CLOCK, ((KernelTransactions)KernelTransactions.this).tracers.transactionTracer, KernelTransactions.this.storageEngine);
            KernelTransactions.this.allTransactions.add(tx);
            return tx;
        }
    };
    private final LinkedQueuePool<KernelTransactionImplementation> globalTxPool = new LinkedQueuePool<KernelTransactionImplementation>(8, this.factory){

        protected void dispose(KernelTransactionImplementation tx) {
            KernelTransactions.this.allTransactions.remove(tx);
            super.dispose((Object)tx);
        }
    };
    private final MarshlandPool<KernelTransactionImplementation> localTxPool = new MarshlandPool(this.globalTxPool);

    public KernelTransactions(Locks locks, ConstraintIndexCreator constraintIndexCreator, StatementOperationParts statementOperations, SchemaWriteGuard schemaWriteGuard, TransactionHeaderInformationFactory txHeaderFactory, TransactionCommitProcess transactionCommitProcess, IndexConfigStore indexConfigStore, LegacyIndexProviderLookup legacyIndexProviderLookup, TransactionHooks hooks, TransactionMonitor transactionMonitor, LifeSupport dataSourceLife, Tracers tracers, StorageEngine storageEngine, Procedures procedures, TransactionIdStore transactionIdStore) {
        this.locks = locks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.statementOperations = statementOperations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionHeaderInformationFactory = txHeaderFactory;
        this.transactionCommitProcess = transactionCommitProcess;
        this.hooks = hooks;
        this.transactionMonitor = transactionMonitor;
        this.dataSourceLife = dataSourceLife;
        this.tracers = tracers;
        this.storageEngine = storageEngine;
        this.procedures = procedures;
        this.transactionIdStore = transactionIdStore;
        this.legacyIndexTxStateSupplier = () -> new CachingLegacyIndexTransactionState(new LegacyIndexTransactionStateImpl(indexConfigStore, legacyIndexProviderLookup));
    }

    public KernelTransaction newInstance(KernelTransaction.Type type, AccessMode accessMode) {
        this.assertDatabaseIsRunning();
        return ((KernelTransactionImplementation)this.localTxPool.acquire()).initialize(this.transactionIdStore.getLastCommittedTransactionId(), this.locks.newClient(), type, accessMode);
    }

    public Set<KernelTransaction> activeTransactions() {
        HashSet<KernelTransaction> output = new HashSet<KernelTransaction>();
        for (KernelTransactionImplementation tx : this.allTransactions) {
            if (!tx.isOpen()) continue;
            output.add(tx);
        }
        return output;
    }

    public void disposeAll() {
        for (KernelTransactionImplementation tx : this.allTransactions) {
            tx.markForTermination();
        }
        this.localTxPool.disposeAll();
        this.globalTxPool.disposeAll();
    }

    public void shutdown() throws Throwable {
        this.disposeAll();
    }

    private void assertDatabaseIsRunning() {
        if (!this.dataSourceLife.isRunning()) {
            throw new DatabaseShutdownException();
        }
    }
}

