/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_1;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_10;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RecordStorageCommandReaderFactory
implements CommandReaderFactory {
    private final CommandReader[] readers = new CommandReader[10];

    public RecordStorageCommandReaderFactory() {
        this.readers[-LogEntryVersion.V2_0.byteCode()] = new PhysicalLogCommandReaderV2_0();
        this.readers[-LogEntryVersion.V2_1.byteCode()] = new PhysicalLogCommandReaderV2_1();
        this.readers[-LogEntryVersion.V2_2.byteCode()] = new PhysicalLogCommandReaderV2_2();
        this.readers[-LogEntryVersion.V2_2_4.byteCode()] = new PhysicalLogCommandReaderV2_2_4();
        this.readers[-LogEntryVersion.V2_3.byteCode()] = new PhysicalLogCommandReaderV2_2_4();
        this.readers[-LogEntryVersion.V3_0.byteCode()] = new PhysicalLogCommandReaderV3_0();
        this.readers[-LogEntryVersion.V2_2_10.byteCode()] = new PhysicalLogCommandReaderV2_2_10();
        this.readers[-LogEntryVersion.V2_3_5.byteCode()] = new PhysicalLogCommandReaderV2_2_10();
        this.readers[-LogEntryVersion.V3_0_2.byteCode()] = new PhysicalLogCommandReaderV3_0_2();
        LogEntryVersion[] versions = LogEntryVersion.values();
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i] != null) continue;
            throw new IllegalStateException("Version " + (Object)((Object)versions[i]) + " not handled");
        }
    }

    @Override
    public CommandReader byVersion(byte version) {
        byte key = (byte)Math.abs(version);
        if (key >= this.readers.length) {
            throw new IllegalArgumentException("Unsupported version:" + version);
        }
        return this.readers[key];
    }
}

