/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.List;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.NodePropertyUpdates;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;

public class LabelScanViewNodeStoreScan<FAILURE extends Exception>
extends StoreViewNodeStoreScan<FAILURE> {
    private final LabelScanStore labelScanStore;
    private boolean outdated;

    public LabelScanViewNodeStoreScan(NodeStore nodeStore, LockService locks, PropertyStore propertyStore, LabelScanStore labelScanStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<NodePropertyUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter) {
        super(nodeStore, locks, propertyStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
        this.labelScanStore = labelScanStore;
    }

    @Override
    public PrimitiveLongResourceIterator getNodeIdIterator() {
        return new LabelScanViewIdIterator(this, this.labelScanStore, this.labelIds);
    }

    @Override
    public void configure(List<MultipleIndexPopulator.IndexPopulation> populations) {
        populations.forEach(population -> population.populator.configureSampling(false));
    }

    @Override
    public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, NodePropertyUpdate update, long currentlyIndexedNodeId) {
        super.acceptUpdate(updater, update, currentlyIndexedNodeId);
        if (update.getNodeId() > currentlyIndexedNodeId) {
            this.markOutdated();
        }
    }

    boolean isOutdated() {
        return this.outdated;
    }

    void clearOutdatedFlag() {
        this.outdated = false;
    }

    private void markOutdated() {
        this.outdated = true;
    }
}

