/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.util.Validator;

public class Validators {
    public static final Validator<File> REGEX_FILE_EXISTS = new Validator<File>(){

        @Override
        public void validate(File file) {
            if (Validators.matchingFiles(file).isEmpty()) {
                throw new IllegalArgumentException("File '" + file + "' doesn't exist");
            }
        }
    };
    public static final Validator<File> DIRECTORY_IS_WRITABLE = new Validator<File>(){

        @Override
        public void validate(File value) {
            if (value.mkdirs()) {
                return;
            }
            File test = new File(value, "_______test___");
            try {
                test.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Directoy '" + value + "' not writable: " + e.getMessage());
            }
            finally {
                test.delete();
            }
        }
    };
    public static final Validator<File> CONTAINS_NO_EXISTING_DATABASE = new Validator<File>(){

        @Override
        public void validate(File value) {
            if (new DefaultFileSystemAbstraction().fileExists(new File(value, StoreFileType.STORE.augment("neostore")))) {
                throw new IllegalArgumentException("Directory '" + value + "' already contains a database");
            }
        }
    };

    static List<File> matchingFiles(File fileWithRegexInName) {
        File parent = fileWithRegexInName.getAbsoluteFile().getParentFile();
        if (parent == null || !parent.exists()) {
            throw new IllegalArgumentException("Directory of " + fileWithRegexInName + " doesn't exist");
        }
        Pattern pattern = Pattern.compile(fileWithRegexInName.getName());
        ArrayList<File> files = new ArrayList<File>();
        for (File file : parent.listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            files.add(file);
        }
        return files;
    }

    public static <T> Validator<T[]> atLeast(final String key, final int length) {
        return new Validator<T[]>(){

            @Override
            public void validate(T[] value) {
                if (value.length < length) {
                    throw new IllegalArgumentException("Expected '" + key + "' to have at least " + length + " valid item" + (length == 1 ? "" : "s") + ", but had " + value.length + " " + Arrays.toString(value));
                }
            }
        };
    }

    public static final <T> Validator<T> emptyValidator() {
        return new Validator<T>(){

            @Override
            public void validate(T value) {
            }
        };
    }
}

