/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.api.store.StorePropertyPayloadCursor;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.PropertyItem;

public class StorePropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private final Consumer<StorePropertyCursor> instanceCache;
    private final StorePropertyPayloadCursor payload;
    private final RecordCursor<PropertyRecord> recordCursor;

    public StorePropertyCursor(RecordCursors cursors, Consumer<StorePropertyCursor> instanceCache) {
        this.instanceCache = instanceCache;
        this.payload = new StorePropertyPayloadCursor(cursors.propertyString(), cursors.propertyArray());
        this.recordCursor = cursors.property();
    }

    public StorePropertyCursor init(long firstPropertyId) {
        this.recordCursor.placeAt(firstPropertyId, RecordLoad.FORCE);
        this.payload.clear();
        return this;
    }

    public boolean next() {
        if (this.payload.next()) {
            return true;
        }
        while (true) {
            if (this.recordCursor.next()) {
                PropertyRecord propertyRecord = (PropertyRecord)this.recordCursor.get();
                this.payload.init(propertyRecord.getBlocks(), propertyRecord.getNumberOfBlocks());
                if (!this.payload.next()) continue;
                return true;
            }
            if (Record.NO_NEXT_PROPERTY.is(((PropertyRecord)this.recordCursor.get()).getNextProp())) break;
        }
        return false;
    }

    @Override
    public int propertyKeyId() {
        return this.payload.propertyKeyId();
    }

    @Override
    public Object value() {
        return this.payload.value();
    }

    public PropertyItem get() {
        return this;
    }

    public void close() {
        this.payload.clear();
        this.instanceCache.accept(this);
    }
}

