/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreIteratorRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private PrimitiveLongIterator iterator;
    private final InstanceCache<StoreIteratorRelationshipCursor> instanceCache;

    public StoreIteratorRelationshipCursor(RelationshipRecord relationshipRecord, InstanceCache<StoreIteratorRelationshipCursor> instanceCache, RecordCursors cursors) {
        super(relationshipRecord, cursors);
        this.instanceCache = instanceCache;
    }

    public StoreIteratorRelationshipCursor init(PrimitiveLongIterator iterator) {
        this.iterator = iterator;
        return this;
    }

    public boolean next() {
        while (this.iterator != null && this.iterator.hasNext()) {
            if (!this.relationshipRecordCursor.next(this.iterator.next(), this.relationshipRecord, RecordLoad.CHECK)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.iterator instanceof Resource) {
            ((Resource)this.iterator).close();
        }
        this.iterator = null;
        this.instanceCache.accept(this);
    }
}

