/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public abstract class StoreAbstractRelationshipCursor
extends EntityItemHelper
implements Cursor<RelationshipItem>,
RelationshipItem {
    protected final RelationshipRecord relationshipRecord;
    protected final RecordCursor<RelationshipRecord> relationshipRecordCursor;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursor;
    private final InstanceCache<StorePropertyCursor> allPropertyCursor;

    public StoreAbstractRelationshipCursor(RelationshipRecord relationshipRecord, final RecordCursors cursors) {
        this.relationshipRecordCursor = cursors.relationship();
        this.relationshipRecord = relationshipRecord;
        this.singlePropertyCursor = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(cursors, this);
            }
        };
        this.allPropertyCursor = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(cursors, this);
            }
        };
    }

    public RelationshipItem get() {
        return this;
    }

    @Override
    public long id() {
        return this.relationshipRecord.getId();
    }

    @Override
    public int type() {
        return this.relationshipRecord.getType();
    }

    @Override
    public long startNode() {
        return this.relationshipRecord.getFirstNode();
    }

    @Override
    public long endNode() {
        return this.relationshipRecord.getSecondNode();
    }

    @Override
    public long otherNode(long nodeId) {
        return this.relationshipRecord.getFirstNode() == nodeId ? this.relationshipRecord.getSecondNode() : this.relationshipRecord.getFirstNode();
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.allPropertyCursor.get().init(this.relationshipRecord.getNextProp());
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.singlePropertyCursor.get().init(this.relationshipRecord.getNextProp(), propertyKeyId);
    }
}

