/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class ExecutionSupervisor {
    private final Clock clock;
    private final ExecutionMonitor monitor;

    public ExecutionSupervisor(Clock clock, ExecutionMonitor monitor) {
        this.clock = clock;
        this.monitor = monitor;
    }

    public ExecutionSupervisor(ExecutionMonitor monitor) {
        this(Clock.SYSTEM_CLOCK, monitor);
    }

    public synchronized void supervise(StageExecution execution) {
        long startTime = this.currentTimeMillis();
        this.start(execution);
        while (execution.stillExecuting()) {
            this.finishAwareSleep(execution);
            this.monitor.check(execution);
        }
        this.end(execution, this.currentTimeMillis() - startTime);
    }

    private long currentTimeMillis() {
        return this.clock.currentTimeMillis();
    }

    protected void end(StageExecution execution, long totalTimeMillis) {
        this.monitor.end(execution, totalTimeMillis);
    }

    protected void start(StageExecution execution) {
        this.monitor.start(execution);
    }

    private void finishAwareSleep(StageExecution execution) {
        long endTime = this.monitor.nextCheckTime();
        while (this.currentTimeMillis() < endTime && execution.stillExecuting()) {
            try {
                Thread.sleep(Math.min(10L, Math.max(0L, endTime - this.currentTimeMillis())));
            }
            catch (InterruptedException e) {
                execution.panic(e);
                break;
            }
        }
    }
}

