/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.exceptions.index.ExceptionDuringFlipKernelException;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class FlippableIndexProxy
implements IndexProxy {
    private volatile boolean closed;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile IndexProxyFactory flipTarget;
    private volatile IndexProxy delegate;

    public FlippableIndexProxy() {
        this(null);
    }

    public FlippableIndexProxy(IndexProxy originalDelegate) {
        this.delegate = originalDelegate;
    }

    @Override
    public void start() throws IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.start();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        this.lock.readLock().lock();
        try {
            LockingIndexUpdater lockingIndexUpdater = new LockingIndexUpdater(this.delegate.newUpdater(mode));
            return lockingIndexUpdater;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.drop();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void force() throws IOException {
        FlippableIndexProxy.barge(this.lock.readLock());
        try {
            this.delegate.force();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        FlippableIndexProxy.barge(this.lock.readLock());
        try {
            this.delegate.flush();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static void barge(ReentrantReadWriteLock.ReadLock lock) {
        boolean interrupted = false;
        long timeout = 10L;
        while (!lock.tryLock()) {
            try {
                if (lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                interrupted = true;
            }
            timeout = Math.min(1000L, timeout * 2L);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public IndexDescriptor getDescriptor() {
        this.lock.readLock().lock();
        try {
            IndexDescriptor indexDescriptor = this.delegate.getDescriptor();
            return indexDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        this.lock.readLock().lock();
        try {
            SchemaIndexProvider.Descriptor descriptor = this.delegate.getProviderDescriptor();
            return descriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public InternalIndexState getState() {
        this.lock.readLock().lock();
        try {
            InternalIndexState internalIndexState = this.delegate.getState();
            return internalIndexState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Future<Void> close() throws IOException {
        this.lock.readLock().lock();
        try {
            this.closed = true;
            Future<Void> future = this.delegate.close();
            return future;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        this.lock.readLock().lock();
        try {
            IndexReader indexReader = this.delegate.newReader();
            return indexReader;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        IndexProxy proxy;
        do {
            this.lock.readLock().lock();
            proxy = this.delegate;
            this.lock.readLock().unlock();
        } while (proxy.awaitStoreScanCompleted());
        return true;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.delegate.activate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException, ConstraintVerificationFailedKernelException {
        this.lock.readLock().lock();
        try {
            this.delegate.validate();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        this.lock.readLock().lock();
        try {
            ResourceIterator<File> resourceIterator = this.delegate.snapshotFiles();
            return resourceIterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        this.lock.readLock().lock();
        try {
            IndexPopulationFailure indexPopulationFailure = this.delegate.getPopulationFailure();
            return indexPopulationFailure;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        this.lock.readLock().lock();
        try {
            PopulationProgress populationProgress = this.delegate.getIndexPopulationProgress();
            return populationProgress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setFlipTarget(IndexProxyFactory flipTarget) {
        this.lock.writeLock().lock();
        try {
            this.flipTarget = flipTarget;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void flipTo(IndexProxy targetDelegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = targetDelegate;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(Callable<Void> actionDuringFlip, FailedIndexProxyFactory failureDelegate) throws FlipFailedKernelException {
        this.lock.writeLock().lock();
        try {
            this.assertOpen();
            try {
                actionDuringFlip.call();
                this.delegate = this.flipTarget.create();
            }
            catch (Exception e) {
                this.delegate = failureDelegate.create(e);
                throw new ExceptionDuringFlipKernelException(e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public IndexConfiguration config() {
        this.lock.readLock().lock();
        try {
            IndexConfiguration indexConfiguration = this.delegate.config();
            return indexConfiguration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " -> " + this.delegate + "[target:" + this.flipTarget + "]";
    }

    private void assertOpen() throws IndexProxyAlreadyClosedKernelException {
        if (this.closed) {
            throw new IndexProxyAlreadyClosedKernelException(this.getClass());
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.lock.readLock().lock();
        try {
            this.delegate.verifyDeferredConstraints(accessor);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private class LockingIndexUpdater
    extends DelegatingIndexUpdater {
        private LockingIndexUpdater(IndexUpdater delegate) {
            super(delegate);
            FlippableIndexProxy.this.lock.readLock().lock();
        }

        @Override
        public void close() throws IOException, IndexEntryConflictException {
            try {
                this.delegate.close();
            }
            finally {
                FlippableIndexProxy.this.lock.readLock().unlock();
            }
        }
    }
}

