/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeRelationshipCache
implements MemoryStatsVisitor.Visitable {
    private static final long EMPTY = -1L;
    private static final byte[] DEFAULT_VALUE = new byte[10];
    private static final long MAX_RELATIONSHIP_ID = 0xFFFFFFFFFFFEL;
    private static final int ID_SIZE = 6;
    private static final int COUNT_SIZE = 4;
    private static final int ID_AND_COUNT_SIZE = 10;
    private static final int SPARSE_ID_OFFSET = 0;
    private static final int SPARSE_COUNT_OFFSET = 6;
    private final ByteArray array;
    private final int denseNodeThreshold;
    private final RelGroupCache relGroupCache;
    public static final GroupVisitor NO_GROUP_VISITOR;

    public NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold) {
        this(arrayFactory, denseNodeThreshold, 1000000, 0L);
    }

    NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, int chunkSize, long base) {
        this.array = arrayFactory.newDynamicByteArray(chunkSize, DEFAULT_VALUE);
        this.denseNodeThreshold = denseNodeThreshold;
        this.relGroupCache = new RelGroupCache(arrayFactory, chunkSize, base);
    }

    public int incrementCount(long nodeId) {
        ByteArray array = (ByteArray)this.array.at(nodeId);
        int count = NodeRelationshipCache.getCount(array, nodeId) + 1;
        this.setCount(array, nodeId, count);
        return count;
    }

    private void setCount(ByteArray array, long nodeId, int count) {
        array.setInt(nodeId, 6, count);
    }

    private static int getCount(ByteArray array, long nodeId) {
        return array.getInt(nodeId, 6);
    }

    public boolean isDense(long nodeId) {
        return this.isDense(this.array, nodeId);
    }

    private boolean isDense(ByteArray array, long nodeId) {
        if ((long)this.denseNodeThreshold == -1L) {
            return false;
        }
        return NodeRelationshipCache.getCount(array, nodeId) >= this.denseNodeThreshold;
    }

    public long getAndPutRelationship(long nodeId, int type, Direction direction, long firstRelId, boolean incrementCount) {
        if (firstRelId > 0xFFFFFFFFFFFEL) {
            throw new IllegalArgumentException("Illegal relationship id, max is 281474976710654");
        }
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long existingId = NodeRelationshipCache.all48Bits(array, nodeId, 0);
        if (this.isDense(array, nodeId)) {
            if (existingId == -1L) {
                existingId = this.relGroupCache.allocate(type, direction, firstRelId, incrementCount);
                this.setRelationshipId(array, nodeId, existingId);
                return -1L;
            }
            return this.relGroupCache.putRelationship(existingId, type, direction, firstRelId, incrementCount);
        }
        this.setRelationshipId(array, nodeId, firstRelId);
        return existingId;
    }

    private void setRelationshipId(ByteArray array, long nodeId, long firstRelId) {
        array.set6ByteLong(nodeId, 0, firstRelId);
    }

    private long getRelationshipId(ByteArray array, long nodeId) {
        return array.get6ByteLong(nodeId, 0);
    }

    private static long all48Bits(ByteArray array, long index, int offset) {
        return NodeRelationshipCache.all48Bits(array.get6ByteLong(index, offset));
    }

    private static long all48Bits(long raw) {
        return raw == -1L ? raw : raw & 0xFFFFFFFFFFFFL;
    }

    public long getFirstRel(long nodeId, GroupVisitor visitor) {
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long id = this.getRelationshipId(array, nodeId);
        if (this.isDense(array, nodeId)) {
            return this.relGroupCache.visitGroups(nodeId, id, visitor);
        }
        return id;
    }

    public void clearRelationships() {
        long length = this.array.length();
        for (long nodeId = 0L; nodeId < length; ++nodeId) {
            if (this.isDense(nodeId)) continue;
            this.setRelationshipId(this.array, nodeId, -1L);
        }
        this.relGroupCache.clearRelationships();
    }

    public int getCount(long nodeId, int type, Direction direction) {
        ByteArray array = (ByteArray)this.array.at(nodeId);
        if (this.isDense(array, nodeId)) {
            long id = this.getRelationshipId(array, nodeId);
            return id == -1L ? 0 : this.relGroupCache.getCount(id, type, direction);
        }
        return NodeRelationshipCache.getCount(array, nodeId);
    }

    public String toString() {
        return this.array.toString();
    }

    public void close() {
        this.array.close();
        this.relGroupCache.close();
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.array.acceptMemoryStatsVisitor(visitor);
        this.relGroupCache.acceptMemoryStatsVisitor(visitor);
    }

    static {
        ByteArray array = NumberArrayFactory.HEAP.newByteArray(1L, (byte[])DEFAULT_VALUE.clone());
        array.set6ByteLong(0L, 0, -1L);
        array.setInt(0L, 6, 0);
        array.get(0L, DEFAULT_VALUE);
        NO_GROUP_VISITOR = new GroupVisitor(){

            @Override
            public long visit(long nodeId, int type, long next, long out, long in, long loop) {
                return -1L;
            }
        };
    }

    private static class RelGroupCache
    implements AutoCloseable,
    MemoryStatsVisitor.Visitable {
        private static final int TYPE_SIZE = 2;
        private static final int NEXT_OFFSET = 0;
        private static final int TYPE_OFFSET = 6;
        private static final int BASE_IDS_OFFSET = 8;
        private static final byte[] DEFAULT_VALUE = new byte[8 + 10 * Direction.values().length];
        private final long base;
        private final ByteArray array;
        private final AtomicLong nextFreeId;

        RelGroupCache(NumberArrayFactory arrayFactory, long chunkSize, long base) {
            this.base = base;
            assert (chunkSize > 0L);
            this.array = arrayFactory.newDynamicByteArray(chunkSize, DEFAULT_VALUE);
            this.nextFreeId = new AtomicLong(base);
        }

        public int getCount(long id, int type, Direction direction) {
            return (id = this.findGroupIndexForType(id, type)) == -1L ? 0 : this.array.getInt(this.rebase(id), this.countOffset(direction));
        }

        private void clearRelationships() {
            long length = this.array.length();
            for (long i = 0L; i < length; ++i) {
                ByteArray array = (ByteArray)this.array.at(i);
                array.set6ByteLong(i, this.directionOffset(Direction.OUTGOING), -1L);
                array.set6ByteLong(i, this.directionOffset(Direction.INCOMING), -1L);
                array.set6ByteLong(i, this.directionOffset(Direction.BOTH), -1L);
            }
        }

        private long rebase(long index) {
            return index - this.base;
        }

        private long nextFreeId() {
            return this.nextFreeId.getAndIncrement();
        }

        private void initializeGroup(ByteArray array, long relGroupIndex, int type) {
            array.setShort(this.rebase(relGroupIndex), 6, (short)type);
        }

        private long visitGroups(long nodeId, long relGroupIndex, GroupVisitor visitor) {
            long currentIndex = relGroupIndex;
            long first = -1L;
            while (currentIndex != -1L) {
                long index = this.rebase(currentIndex);
                ByteArray array = (ByteArray)this.array.at(index);
                short type = array.getShort(index, 6);
                long out = NodeRelationshipCache.all48Bits(array, index, this.directionOffset(Direction.OUTGOING));
                long in = NodeRelationshipCache.all48Bits(array, index, this.directionOffset(Direction.INCOMING));
                long loop = NodeRelationshipCache.all48Bits(array, index, this.directionOffset(Direction.BOTH));
                long next = NodeRelationshipCache.all48Bits(array, index, 0);
                long id = visitor.visit(nodeId, type, next, out, in, loop);
                if (first == -1L) {
                    first = id;
                }
                currentIndex = next;
            }
            return first;
        }

        private int directionOffset(Direction direction) {
            return 8 + direction.ordinal() * 10;
        }

        private int countOffset(Direction direction) {
            return this.directionOffset(direction) + 6;
        }

        public long allocate(int type, Direction direction, long relId, boolean incrementCount) {
            long index = this.nextFreeId();
            ByteArray array = (ByteArray)this.array.at(this.rebase(index));
            this.initializeGroup(array, index, type);
            this.putRelField(array, index, direction, relId, incrementCount);
            return index;
        }

        private long putRelField(ByteArray array, long relGroupIndex, Direction direction, long relId, boolean increment) {
            long index = this.rebase(relGroupIndex);
            int directionOffset = this.directionOffset(direction);
            long previousId = NodeRelationshipCache.all48Bits(array, index, directionOffset);
            array.set6ByteLong(index, directionOffset, relId);
            if (increment) {
                int countOffset = this.countOffset(direction);
                array.setInt(index, countOffset, array.getInt(index, countOffset) + 1);
            }
            return previousId;
        }

        public long putRelationship(long relGroupIndex, int type, Direction direction, long relId, boolean trueForIncrement) {
            ByteArray array;
            long currentIndex = relGroupIndex;
            long previousIndex = -1L;
            while (currentIndex != -1L) {
                long currentIndexRebased = this.rebase(currentIndex);
                array = (ByteArray)this.array.at(currentIndexRebased);
                long foundType = array.getShort(currentIndexRebased, 6);
                if (foundType == (long)type) {
                    return this.putRelField(array, currentIndex, direction, relId, trueForIncrement);
                }
                if (foundType > (long)type) break;
                previousIndex = currentIndex;
                currentIndex = NodeRelationshipCache.all48Bits(array, currentIndexRebased, 0);
            }
            long newIndex = this.nextFreeId();
            if (previousIndex == -1L) {
                this.array.swap(this.rebase(currentIndex), this.rebase(newIndex), 1);
                long swap = newIndex;
                newIndex = currentIndex;
                currentIndex = swap;
            }
            array = (ByteArray)this.array.at(this.rebase(newIndex));
            this.initializeGroup(array, newIndex, type);
            if (currentIndex != -1L) {
                this.setNextField(array, newIndex, currentIndex);
            }
            if (previousIndex != -1L) {
                this.setNextField(this.array, previousIndex, newIndex);
            }
            return this.putRelField(array, newIndex, direction, relId, trueForIncrement);
        }

        private void setNextField(ByteArray array, long relGroupIndex, long next) {
            array.set6ByteLong(this.rebase(relGroupIndex), 0, next);
        }

        private long findGroupIndexForType(long relGroupIndex, int type) {
            long currentIndex = relGroupIndex;
            while (currentIndex != -1L) {
                long index = this.rebase(currentIndex);
                short foundType = this.array.getShort(index, 6);
                if (foundType == type) {
                    return currentIndex;
                }
                if (foundType > type) break;
                currentIndex = NodeRelationshipCache.all48Bits(this.array, index, 0);
            }
            return -1L;
        }

        @Override
        public void close() {
            this.array.close();
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
            this.array.acceptMemoryStatsVisitor(visitor);
        }

        static {
            ByteArray defaultArray = NumberArrayFactory.HEAP.newByteArray(1L, (byte[])DEFAULT_VALUE.clone());
            defaultArray.set6ByteLong(0L, 0, -1L);
            defaultArray.setShort(0L, 6, (short)-1);
            int i = 0;
            int offsetBase = 8;
            while (i < Direction.values().length) {
                defaultArray.set6ByteLong(0L, offsetBase, -1L);
                defaultArray.setInt(0L, offsetBase + 6, 0);
                ++i;
                offsetBase += 10;
            }
            defaultArray.get(0L, DEFAULT_VALUE);
        }
    }

    public static interface GroupVisitor {
        public long visit(long var1, int var3, long var4, long var6, long var8, long var10);
    }
}

