/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class BatchingDynamicRecordAllocator
implements DynamicRecordAllocator {
    private final int dataSize = Integer.parseInt(GraphDatabaseSettings.string_block_size.getDefaultValue()) - 8;
    private final IdSequence idSequence;
    private final List<DynamicRecord> records = new ArrayList<DynamicRecord>();

    public BatchingDynamicRecordAllocator() {
        this(new BatchingIdSequence());
    }

    public BatchingDynamicRecordAllocator(IdSequence idSequence) {
        this.idSequence = idSequence;
    }

    @Override
    public int getRecordDataSize() {
        return this.dataSize;
    }

    @Override
    public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
        DynamicRecord record = new DynamicRecord(this.idSequence.nextId());
        record.setInUse(true);
        this.records.add(record);
        return record;
    }

    public List<DynamicRecord> records() {
        return this.records;
    }
}

