/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipRecordFormatV2_0
extends BaseOneByteHeaderRecordFormat<RelationshipRecord> {
    RelationshipRecordFormatV2_0() {
        super(RelationshipRecordFormatV2_0.fixedRecordSize(33), 0, 1, 35);
    }

    @Override
    public RelationshipRecord newRecord() {
        return new RelationshipRecord(-1L);
    }

    @Override
    public void read(RelationshipRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) throws IOException {
        long headerByte = cursor.getByte();
        boolean inUse = this.isInUse((byte)headerByte);
        if (mode.shouldLoad(inUse)) {
            long firstNode = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstNodeMod = (headerByte & 0xEL) << 31;
            long secondNode = (long)cursor.getInt() & 0xFFFFFFFFL;
            long typeInt = cursor.getInt();
            long secondNodeMod = (typeInt & 0x70000000L) << 4;
            int type = (int)(typeInt & 0xFFFFL);
            long firstPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
            long firstNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
            long secondPrevRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long secondPrevRelMod = (typeInt & 0x380000L) << 13;
            long secondNextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long secondNextRelMod = (typeInt & 0x70000L) << 16;
            long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
            long nextPropMod = (headerByte & 0xF0L) << 28;
            record.initialize(inUse, RelationshipRecordFormatV2_0.longFromIntAndMod(nextProp, nextPropMod), RelationshipRecordFormatV2_0.longFromIntAndMod(firstNode, firstNodeMod), RelationshipRecordFormatV2_0.longFromIntAndMod(secondNode, secondNodeMod), type, RelationshipRecordFormatV2_0.longFromIntAndMod(firstPrevRel, firstPrevRelMod), RelationshipRecordFormatV2_0.longFromIntAndMod(firstNextRel, firstNextRelMod), RelationshipRecordFormatV2_0.longFromIntAndMod(secondPrevRel, secondPrevRelMod), RelationshipRecordFormatV2_0.longFromIntAndMod(secondNextRel, secondNextRelMod), false, false);
        }
    }

    @Override
    public void write(RelationshipRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) throws IOException {
        throw new UnsupportedOperationException();
    }
}

