/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class PropertyRecordFormat
extends BaseRecordFormat<PropertyRecord> {
    public static final int DEFAULT_DATA_BLOCK_SIZE = 120;
    public static final int DEFAULT_PAYLOAD_SIZE = 32;
    public static final int RECORD_SIZE = 41;

    public PropertyRecordFormat() {
        super(PropertyRecordFormat.fixedRecordSize(41), 0, 36);
    }

    @Override
    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    @Override
    public void read(PropertyRecord record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) {
        long block;
        PropertyType type;
        int offsetAtBeginning = cursor.getOffset();
        byte modifiers = cursor.getByte();
        long prevMod = ((long)modifiers & 0xF0L) << 28;
        long nextMod = ((long)modifiers & 0xFL) << 32;
        long prevProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
        record.initialize(false, BaseRecordFormat.longFromIntAndMod(prevProp, prevMod), BaseRecordFormat.longFromIntAndMod(nextProp, nextMod));
        while (cursor.getOffset() - offsetAtBeginning < 41 && (type = PropertyType.getPropertyType(block = cursor.getLong(), true)) != null) {
            record.setInUse(true);
            record.addLoadedBlock(block);
            int additionalBlocks = type.calculateNumberOfBlocksUsed(block) - 1;
            while (additionalBlocks-- > 0) {
                record.addLoadedBlock(cursor.getLong());
            }
        }
    }

    @Override
    public void write(PropertyRecord record, PageCursor cursor, int recordSize, PagedFile storeFile) {
        if (record.inUse()) {
            short prevModifier = record.getPrevProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getPrevProp() & 0xF00000000L) >> 28);
            short nextModifier = record.getNextProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getNextProp() & 0xF00000000L) >> 32);
            byte modifiers = (byte)(prevModifier | nextModifier);
            cursor.putByte(modifiers);
            cursor.putInt((int)record.getPrevProp());
            cursor.putInt((int)record.getNextProp());
            int longsAppended = 0;
            for (PropertyBlock block : record) {
                long[] propBlockValues;
                for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
                    cursor.putLong(propBlockValue);
                }
                longsAppended += propBlockValues.length;
            }
            if (longsAppended < PropertyType.getPayloadSizeLongs()) {
                cursor.putLong(0L);
            }
        } else {
            cursor.setOffset(cursor.getOffset() + 9);
            cursor.putLong(0L);
        }
    }

    @Override
    public long getNextRecordReference(PropertyRecord record) {
        return record.getNextProp();
    }

    @Override
    public boolean isInUse(PageCursor cursor) {
        cursor.setOffset(cursor.getOffset() + 1 + 4 + 4);
        int blocks = PropertyType.getPayloadSizeLongs();
        for (int i = 0; i < blocks; ++i) {
            long block = cursor.getLong();
            if (PropertyType.getPropertyType(block, true) == null) continue;
            return true;
        }
        return false;
    }
}

