/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.query.TransactionalContext;

public abstract class QuerySession {
    private final Map<MetadataKey<?>, Object> metadata = new HashMap();

    public QuerySession(TransactionalContext context) {
        this.put(TransactionalContext.METADATA_KEY, context);
    }

    public abstract String toString();

    public final <ValueType> ValueType put(MetadataKey<ValueType> key, ValueType value) {
        return (ValueType)((MetadataKey)key).valueType.cast(this.metadata.put(key, value));
    }

    public final <ValueType> ValueType get(MetadataKey<ValueType> key) {
        return (ValueType)((MetadataKey)key).valueType.cast(this.metadata.get(key));
    }

    public final <ValueType> ValueType remove(MetadataKey<ValueType> key) {
        return (ValueType)((MetadataKey)key).valueType.cast(this.metadata.remove(key));
    }

    public static final class MetadataKey<ValueType> {
        private final Class<ValueType> valueType;
        private final String name;

        public MetadataKey(Class<ValueType> valueType, String name) {
            this.valueType = valueType;
            this.name = name;
        }

        public String toString() {
            return String.format("QuerySession.MetadataKey(%s:%s)", this.name, this.valueType.getName());
        }
    }
}

