/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.docs;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.docs.SettingsDocumenter;

public class GenerateConfigDocumentation {
    private static Function<String, Class<?>> classFromString = className -> {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    };

    public static void main(String[] argv) throws Exception {
        Args arguments = Args.parse(argv);
        File output = arguments.has("o") ? new File(arguments.get("o")) : null;
        List<String> settingsClasses = arguments.orphans();
        if (settingsClasses.size() == 0) {
            System.out.println("Usage: GenerateConfigDocumentation [-o output file] SETTINGS_CLASS..");
            System.exit(0);
        }
        String doc = new SettingsDocumenter().document(settingsClasses.stream().map(classFromString));
        if (output != null) {
            System.out.println("Saving docs in '" + output.getAbsolutePath() + "'.");
            FileUtils.writeToFile((File)output, (String)doc, (boolean)false);
        } else {
            System.out.println(doc);
        }
    }
}

