/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

public interface Configuration {
    public static final Configuration DEFAULT = new Default();

    public int batchSize();

    public int movingAverageSize();

    public int maxNumberOfProcessors();

    public static class Overridden
    implements Configuration {
        private final Configuration defaults;

        public Overridden(Configuration defaults) {
            this.defaults = defaults;
        }

        @Override
        public int batchSize() {
            return this.defaults.batchSize();
        }

        @Override
        public int movingAverageSize() {
            return this.defaults.movingAverageSize();
        }

        @Override
        public int maxNumberOfProcessors() {
            return this.defaults.maxNumberOfProcessors();
        }
    }

    public static class Default
    implements Configuration {
        @Override
        public int batchSize() {
            return 20000;
        }

        @Override
        public int movingAverageSize() {
            return 1000;
        }

        @Override
        public int maxNumberOfProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }
}

