/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.statistics.IntCounter;
import org.neo4j.kernel.impl.util.statistics.LocalIntCounter;

public class RecordChanges<KEY, RECORD, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private Map<KEY, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> recordChanges = new HashMap<KEY, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>>();
    private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
    private final IntCounter changeCounter;

    public RecordChanges(RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader, IntCounter globalCounter) {
        this.loader = loader;
        this.changeCounter = new LocalIntCounter(globalCounter);
    }

    public String toString() {
        return "RecordChanges{recordChanges=" + this.recordChanges + '}';
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getIfLoaded(KEY key) {
        return this.recordChanges.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> result = this.recordChanges.get(key);
        if (result == null) {
            RECORD record = this.loader.load(key, additionalData);
            result = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData);
        }
        return result;
    }

    @Override
    public void setTo(KEY key, RECORD newRecord, ADDITIONAL additionalData) {
        RecordChange<KEY, RECORD, ADDITIONAL> recordChange = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, newRecord, this.loader, false, additionalData);
        this.recordChanges.put(key, recordChange);
        recordChange.forChangingData();
    }

    @Override
    public int changeSize() {
        return this.changeCounter.value();
    }

    @Override
    public void close() {
        if (this.recordChanges.size() <= 32) {
            this.recordChanges.clear();
        } else {
            this.recordChanges = new HashMap<KEY, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>>();
        }
        this.changeCounter.clear();
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<KEY, RECORD, ADDITIONAL> change = new RecordChange<KEY, RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, true, additionalData);
        this.recordChanges.put(key, change);
        return change;
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> changes() {
        return Iterables.filter(RecordAccess.RecordProxy::isChanged, this.recordChanges.values());
    }

    public static class RecordChange<KEY, RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private final Map<KEY, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> allChanges;
        private final IntCounter changeCounter;
        private final RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader;
        private final ADDITIONAL additionalData;
        private final RECORD record;
        private final boolean created;
        private final KEY key;
        private RECORD before;
        private boolean changed;

        public RecordChange(Map<KEY, RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL>> allChanges, IntCounter changeCounter, KEY key, RECORD record, RecordAccess.Loader<KEY, RECORD, ADDITIONAL> loader, boolean created, ADDITIONAL additionalData) {
            this.allChanges = allChanges;
            this.changeCounter = changeCounter;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.created = created;
            this.additionalData = additionalData;
        }

        public String toString() {
            return "RecordChange{record=" + this.record + "key=" + this.key + "created=" + this.created + '}';
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy();
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                RecordAccess.RecordProxy previous = this.allChanges.put(this.key, this);
                if (previous == null || !previous.isChanged()) {
                    this.changeCounter.increment();
                }
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy() {
            if (!this.created) {
                this.loader.ensureHeavy(this.record);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy();
            return this.record;
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.loader.clone(this.record);
            }
        }

        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

