/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class IntegrityValidator {
    private final NeoStores neoStores;
    private final IndexingService indexes;

    public IntegrityValidator(NeoStores neoStores, IndexingService indexes) {
        this.neoStores = neoStores;
        this.indexes = indexes;
    }

    public void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw new ConstraintViolationTransactionFailureException("Cannot delete node<" + record.getId() + ">, because it still has relationships. " + "To delete this node, you must first delete its relationships.");
        }
    }

    public void validateTransactionStartKnowledge(long lastCommittedTxWhenTransactionStarted) throws TransactionFailureException {
        long latestConstraintIntroducingTx = this.neoStores.getMetaDataStore().getLatestConstraintIntroducingTx();
        if (lastCommittedTxWhenTransactionStarted < latestConstraintIntroducingTx) {
            throw new TransactionFailureException((Status)Status.Transaction.ConstraintsChanged, "Database constraints have changed (txId=%d) after this transaction (txId=%d) started, which is not yet supported. Please retry your transaction to ensure all constraints are executed.", latestConstraintIntroducingTx, lastCommittedTxWhenTransactionStarted);
        }
    }

    public void validateSchemaRule(SchemaRule schemaRule) throws TransactionFailureException {
        if (schemaRule instanceof UniquePropertyConstraintRule) {
            try {
                this.indexes.validateIndex(((UniquePropertyConstraintRule)schemaRule).getOwnedIndex());
            }
            catch (ConstraintVerificationFailedKernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, (Throwable)e, "Index validation failed", new Object[0]);
            }
            catch (IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, (Throwable)e, "Index population failure", new Object[0]);
            }
        }
    }
}

