/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private final TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final CheckPointThreshold threshold;
    private final StorageEngine storageEngine;
    private final LogPruning logPruning;
    private final DatabaseHealth databaseHealth;
    private final Log msgLog;
    private final CheckPointTracer tracer;
    private final Lock lock;
    private long lastCheckPointedTx;

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, StorageEngine storageEngine, LogPruning logPruning, TransactionAppender appender, DatabaseHealth databaseHealth, LogProvider logProvider, CheckPointTracer tracer) {
        this(transactionIdStore, threshold, storageEngine, logPruning, appender, databaseHealth, logProvider, tracer, new ReentrantLock());
    }

    public CheckPointerImpl(TransactionIdStore transactionIdStore, CheckPointThreshold threshold, StorageEngine storageEngine, LogPruning logPruning, TransactionAppender appender, DatabaseHealth databaseHealth, LogProvider logProvider, CheckPointTracer tracer, Lock lock) {
        this.appender = appender;
        this.transactionIdStore = transactionIdStore;
        this.threshold = threshold;
        this.storageEngine = storageEngine;
        this.logPruning = logPruning;
        this.databaseHealth = databaseHealth;
        this.msgLog = logProvider.getLog(CheckPointerImpl.class);
        this.tracer = tracer;
        this.lock = lock;
    }

    public void start() throws Throwable {
        this.threshold.initialize(this.transactionIdStore.getLastClosedTransactionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        this.lock.lock();
        try {
            long l = this.doCheckPoint(info, LogCheckPointEvent.NULL);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        if (this.lock.tryLock()) {
            try {
                long l = this.doCheckPoint(info, LogCheckPointEvent.NULL);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }
        this.lock.lock();
        try {
            this.msgLog.info(info.describe(this.lastCheckPointedTx) + " Check pointing was already running, completed now");
            long l = this.lastCheckPointedTx;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        this.lock.lock();
        try {
            if (this.threshold.isCheckPointingNeeded(this.transactionIdStore.getLastClosedTransactionId(), info)) {
                try (LogCheckPointEvent event = this.tracer.beginCheckPoint();){
                    long l = this.doCheckPoint(info, event);
                    return l;
                }
            }
            long l = -1L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long doCheckPoint(TriggerInfo triggerInfo, LogCheckPointEvent logCheckPointEvent) throws IOException {
        long[] lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        long lastClosedTransactionId = lastClosedTransaction[0];
        LogPosition logPosition = new LogPosition(lastClosedTransaction[1], lastClosedTransaction[2]);
        String prefix = triggerInfo.describe(lastClosedTransactionId);
        this.msgLog.info(prefix + " Starting check pointing...");
        this.databaseHealth.assertHealthy(IOException.class);
        this.msgLog.info(prefix + " Starting store flush...");
        this.storageEngine.flushAndForce();
        this.msgLog.info(prefix + " Store flush completed");
        this.databaseHealth.assertHealthy(IOException.class);
        this.msgLog.info(prefix + " Starting appending check point entry into the tx log...");
        this.appender.checkPoint(logPosition, logCheckPointEvent);
        this.threshold.checkPointHappened(lastClosedTransactionId);
        this.msgLog.info(prefix + " Appending check point entry into the tx log completed");
        this.msgLog.info(prefix + " Check pointing completed");
        this.logPruning.pruneLogs(logPosition.getLogVersion());
        this.lastCheckPointedTx = lastClosedTransactionId;
        return lastClosedTransactionId;
    }
}

