/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;

public class PhysicalLogFiles {
    private final File logBaseName;
    private final Pattern logFilePattern;
    private final FileSystemAbstraction fileSystem;

    public PhysicalLogFiles(File directory, String name, FileSystemAbstraction fileSystem) {
        this.logBaseName = new File(directory, name);
        this.logFilePattern = Pattern.compile(name + "\\." + "\\d+");
        this.fileSystem = fileSystem;
    }

    public PhysicalLogFiles(File directory, FileSystemAbstraction fileSystem) {
        this(directory, "neostore.transaction.db", fileSystem);
    }

    public File getLogFileForVersion(long version) {
        return new File(this.logBaseName.getPath() + "." + version);
    }

    public boolean versionExists(long version) {
        return this.fileSystem.fileExists(this.getLogFileForVersion(version));
    }

    public LogHeader extractHeader(long version) throws IOException {
        return LogHeaderReader.readLogHeader(this.fileSystem, this.getLogFileForVersion(version));
    }

    public boolean hasAnyEntries(long version) {
        return this.fileSystem.getFileSize(this.getLogFileForVersion(version)) > 16L;
    }

    public long getHighestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept(visitor);
        return visitor.highest;
    }

    public long getLowestLogVersion() {
        RangeLogVersionVisitor visitor = new RangeLogVersionVisitor();
        this.accept(visitor);
        return visitor.lowest;
    }

    public void accept(LogVersionVisitor visitor) {
        for (File file : this.fileSystem.listFiles(this.logBaseName.getParentFile())) {
            if (!this.logFilePattern.matcher(file.getName()).matches()) continue;
            visitor.visit(file, PhysicalLogFiles.getLogVersion(file));
        }
    }

    public static long getLogVersion(File historyLogFile) {
        return PhysicalLogFiles.getLogVersion(historyLogFile.getName());
    }

    public static long getLogVersion(String historyLogFilename) {
        int index = historyLogFilename.lastIndexOf(".");
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFilename + "'");
        }
        return Long.parseLong(historyLogFilename.substring(index + ".".length()));
    }

    private static class RangeLogVersionVisitor
    implements LogVersionVisitor {
        private long lowest = -1L;
        private long highest = -1L;

        private RangeLogVersionVisitor() {
        }

        @Override
        public void visit(File file, long logVersion) {
            this.highest = Math.max(this.highest, logVersion);
            this.lowest = this.lowest == -1L ? logVersion : Math.min(this.lowest, logVersion);
        }
    }

    public static interface LogVersionVisitor {
        public void visit(File var1, long var2);
    }
}

