/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class NeoStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final LockGroup lockGroup;
    private final long transactionId;
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private LockService lockService;

    public NeoStoreTransactionApplier(NeoStores neoStores, CacheAccessBackDoor cacheAccess, LockService lockService, long transactionId, LockGroup lockGroup) {
        this.lockGroup = lockGroup;
        this.transactionId = transactionId;
        this.lockService = lockService;
        this.neoStores = neoStores;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void close() throws Exception {
        this.lockGroup.close();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.lockGroup.add(this.lockService.acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        this.neoStores.getNodeStore().updateRecord((NodeRecord)command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getKey(), LockService.LockType.WRITE_LOCK));
        this.neoStores.getRelationshipStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        if (command.getNodeId() != -1L) {
            this.lockGroup.add(this.lockService.acquireNodeLock(command.getNodeId(), LockService.LockType.WRITE_LOCK));
        } else if (command.getRelId() != -1L) {
            this.lockGroup.add(this.lockService.acquireRelationshipLock(command.getRelId(), LockService.LockType.WRITE_LOCK));
        }
        this.neoStores.getPropertyStore().updateRecord((PropertyRecord)command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.neoStores.getRelationshipGroupStore().updateRecord((RelationshipGroupRecord)command.getAfter());
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.neoStores.getRelationshipTypeTokenStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.neoStores.getLabelTokenStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.neoStores.getPropertyKeyTokenStore().updateRecord(command.getAfter());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            schemaStore.updateRecord(record);
        }
        if (command.getSchemaRule() instanceof PropertyConstraintRule) {
            switch (command.getMode()) {
                case UPDATE: 
                case CREATE: {
                    this.neoStores.getMetaDataStore().setLatestConstraintIntroducingTx(this.transactionId);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        switch (command.getMode()) {
            case DELETE: {
                this.cacheAccess.removeSchemaRuleFromCache(command.getKey());
                break;
            }
            default: {
                this.cacheAccess.addSchemaRule(command.getSchemaRule());
            }
        }
        return false;
    }

    @Override
    public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
        this.neoStores.getMetaDataStore().setGraphNextProp(((NeoStoreRecord)command.getAfter()).getNextProp());
        return false;
    }
}

