/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public enum RecordLoad {
    NORMAL{

        @Override
        public boolean shouldLoad(boolean inUse) {
            return inUse;
        }

        @Override
        public boolean verify(AbstractBaseRecord record) {
            if (!record.inUse()) {
                throw new InvalidRecordException(record + " not in use");
            }
            return true;
        }
    }
    ,
    CHECK{

        @Override
        public boolean shouldLoad(boolean inUse) {
            return inUse;
        }

        @Override
        public boolean verify(AbstractBaseRecord record) {
            return record.inUse();
        }

        @Override
        public void report(String message) {
        }
    }
    ,
    FORCE{

        @Override
        public boolean shouldLoad(boolean inUse) {
            return true;
        }

        @Override
        public boolean verify(AbstractBaseRecord record) {
            return true;
        }

        @Override
        public void report(String message) {
        }
    };


    public abstract boolean shouldLoad(boolean var1);

    public abstract boolean verify(AbstractBaseRecord var1);

    public void report(String message) {
        throw new InvalidRecordException(message);
    }
}

