/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.lowlimit;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.TokenRecord;

public abstract class TokenRecordFormat<RECORD extends TokenRecord>
extends BaseOneByteHeaderRecordFormat<RECORD> {
    protected static final int BASE_RECORD_SIZE = 5;

    protected TokenRecordFormat(int recordSize) {
        super(TokenRecordFormat.fixedRecordSize(recordSize), 0, 1);
    }

    @Override
    public void read(RECORD record, PageCursor cursor, RecordLoad mode, int recordSize, PagedFile storeFile) {
        byte inUseByte = cursor.getByte();
        boolean inUse = this.isInUse(inUseByte);
        if (mode.shouldLoad(inUse)) {
            this.readRecordData(cursor, record, inUse);
        }
    }

    protected void readRecordData(PageCursor cursor, RECORD record, boolean inUse) {
        ((TokenRecord)record).initialize(inUse, cursor.getInt());
    }

    @Override
    public void write(RECORD record, PageCursor cursor, int recordSize, PagedFile storeFile) {
        if (((AbstractBaseRecord)record).inUse()) {
            cursor.putByte(Record.IN_USE.byteValue());
            this.writeRecordData(record, cursor);
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
        }
    }

    protected void writeRecordData(RECORD record, PageCursor cursor) {
        cursor.putInt(((TokenRecord)record).getNameId());
    }
}

