/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Arrays;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_0;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_1;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_2;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV2_3;
import org.neo4j.kernel.impl.store.format.lowlimit.LowLimitV3_0;

public class InternalRecordFormatSelector {
    private static final String COMMUNITY_KEY = "community";
    private static final RecordFormats FALLBACK = LowLimitV3_0.RECORD_FORMATS;
    private static final Iterable<RecordFormats> KNOWN_FORMATS = Arrays.asList(LowLimitV2_0.RECORD_FORMATS, LowLimitV2_1.RECORD_FORMATS, LowLimitV2_2.RECORD_FORMATS, LowLimitV2_3.RECORD_FORMATS, LowLimitV3_0.RECORD_FORMATS);

    private static Iterable<RecordFormats.Factory> loadAdditionalFormats() {
        return Service.load(RecordFormats.Factory.class);
    }

    public static RecordFormats select() {
        return InternalRecordFormatSelector.select(Config.empty(), NullLogService.getInstance());
    }

    public static RecordFormats select(Config config, LogService logging) {
        String key = config.get(GraphDatabaseFacadeFactory.Configuration.record_format);
        for (RecordFormats.Factory candidate : InternalRecordFormatSelector.loadAdditionalFormats()) {
            String candidateId = candidate.getKeys().iterator().next();
            if (candidateId.equals(key)) {
                return candidate.newInstance();
            }
            if (!key.equals("")) continue;
            return InternalRecordFormatSelector.loggedSelection(candidate.newInstance(), candidateId, logging);
        }
        if (key.equals(COMMUNITY_KEY)) {
            return FALLBACK;
        }
        if (key.equals("")) {
            return InternalRecordFormatSelector.loggedSelection(FALLBACK, COMMUNITY_KEY, logging);
        }
        throw new IllegalArgumentException("No record format found with the name '" + key + "'.");
    }

    private static RecordFormats loggedSelection(RecordFormats format, String candidateId, LogService logging) {
        logging.getInternalLog(CommunityFacadeFactory.class).info("No record format specified, defaulting to '" + candidateId + "'");
        return format;
    }

    public static RecordFormats fromVersion(String storeVersion) {
        Iterable additionalFormats = Iterables.map(factory -> factory.newInstance(), InternalRecordFormatSelector.loadAdditionalFormats());
        for (RecordFormats format : Iterables.concat((Iterable[])new Iterable[]{KNOWN_FORMATS, additionalFormats})) {
            if (!format.storeVersion().equals(storeVersion)) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown store version '" + storeVersion + "'");
    }
}

