/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;

public class ComposableRecordStore<RECORD extends AbstractBaseRecord, HEADER extends StoreHeader>
extends CommonAbstractStore<RECORD> {
    protected final RecordFormat<RECORD> recordFormat;
    protected final StoreHeaderFormat<HEADER> storeHeaderFormat;
    protected HEADER storeHeader;

    public ComposableRecordStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, String typeDescriptor, RecordFormat<RECORD> recordFormat, String storeVersion, StoreHeaderFormat<HEADER> storeHeaderFormat) {
        super(fileName, configuration, idType, idGeneratorFactory, pageCache, logProvider, typeDescriptor, storeVersion);
        this.recordFormat = recordFormat;
        this.storeHeaderFormat = storeHeaderFormat;
    }

    @Override
    public RECORD newRecord() {
        return this.recordFormat.newRecord();
    }

    @Override
    protected int determineRecordSize() {
        return this.recordFormat.getRecordSize((StoreHeader)this.storeHeader);
    }

    @Override
    public int getRecordDataSize() {
        return this.recordSize - this.recordFormat.getRecordHeaderSize();
    }

    @Override
    protected void readRecord(PageCursor cursor, RECORD record, RecordLoad mode) throws IOException {
        this.recordFormat.read(record, cursor, mode, this.recordSize, this.storeFile);
    }

    @Override
    protected void writeRecord(PageCursor cursor, RECORD record) throws IOException {
        this.recordFormat.write(record, cursor, this.recordSize, this.storeFile);
    }

    @Override
    public void prepareForCommit(RECORD record) {
        if (((AbstractBaseRecord)record).inUse()) {
            this.recordFormat.prepare(record, this.recordSize, this);
        }
    }

    @Override
    public long getNextRecordReference(RECORD record) {
        return this.recordFormat.getNextRecordReference(record);
    }

    @Override
    protected void createHeaderRecord(PageCursor cursor) throws IOException {
        int offset = cursor.getOffset();
        this.storeHeaderFormat.writeHeader(cursor);
        cursor.setOffset(offset);
        this.readHeaderAndInitializeRecordFormat(cursor);
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return this.storeHeaderFormat.numberOfReservedRecords();
    }

    @Override
    protected void readHeaderAndInitializeRecordFormat(PageCursor cursor) throws IOException {
        this.storeHeader = this.storeHeaderFormat.readHeader(cursor);
    }

    @Override
    protected boolean isInUse(PageCursor cursor) {
        return this.recordFormat.isInUse(cursor);
    }

    @Override
    public int getStoreHeaderInt() {
        return ((IntStoreHeader)this.storeHeader).value();
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, RECORD record) throws FAILURE {
        throw new UnsupportedOperationException();
    }
}

