/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.LinkedList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;

public abstract class CommonAbstractStore<RECORD extends AbstractBaseRecord>
implements RecordStore<RECORD>,
AutoCloseable {
    public static final String UNKNOWN_VERSION = "Unknown";
    protected final Config configuration;
    protected final PageCache pageCache;
    protected final File storageFileName;
    protected final IdType idType;
    protected final IdGeneratorFactory idGeneratorFactory;
    protected final Log log;
    protected PagedFile storeFile;
    protected final String storeVersion;
    private IdGenerator idGenerator;
    private boolean storeOk = true;
    private Throwable causeOfStoreNotOk;
    private final String typeDescriptor;
    protected int recordSize;

    public CommonAbstractStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, String typeDescriptor, String storeVersion) {
        this.storageFileName = fileName;
        this.configuration = configuration;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.idType = idType;
        this.typeDescriptor = typeDescriptor;
        this.storeVersion = storeVersion;
        this.log = logProvider.getLog(this.getClass());
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    void initialise(boolean createIfNotExists) {
        try {
            this.checkStorage(createIfNotExists);
            this.loadStorage();
        }
        catch (Exception e) {
            if (this.storeFile != null) {
                try {
                    this.closeStoreFile();
                }
                catch (IOException failureToClose) {
                    e.addSuppressed(failureToClose);
                }
            }
            throw Exceptions.launderedException(e);
        }
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    protected void checkStorage(boolean createIfNotExists) {
        int pageSize = this.pageCache.pageSize();
        try {
            PagedFile ignore = this.pageCache.map(this.storageFileName, pageSize, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            if (createIfNotExists) {
                try (PagedFile file = this.pageCache.map(this.storageFileName, pageSize, new OpenOption[]{StandardOpenOption.CREATE});){
                    this.initialiseNewStoreFile(file);
                    return;
                }
                catch (IOException e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new StoreNotFoundException("Store file not found: " + this.storageFileName, e);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to open store file: " + this.storageFileName, e);
        }
    }

    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        if (this.getNumberOfReservedLowIds() > 0) {
            try (PageCursor pageCursor = file.io(0L, 2);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset(0);
                        this.createHeaderRecord(pageCursor);
                    } while (pageCursor.shouldRetry());
                }
            }
        }
        this.recordSize = this.determineRecordSize();
        File idFileName = new File(this.storageFileName.getPath() + ".id");
        this.idGeneratorFactory.create(idFileName, this.getNumberOfReservedLowIds(), true);
    }

    protected void createHeaderRecord(PageCursor cursor) throws IOException {
        assert (this.getNumberOfReservedLowIds() == 0);
    }

    protected void loadStorage() {
        try {
            this.extractHeaderRecord();
            int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % this.getRecordSize();
            this.storeFile = this.pageCache.map(this.getStorageFileName(), filePageSize, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.loadIdGenerator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractHeaderRecord() throws IOException {
        block27: {
            if (this.getNumberOfReservedLowIds() > 0) {
                try (PagedFile pagedFile = this.pageCache.map(this.getStorageFileName(), this.pageCache.pageSize(), new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
                     PageCursor pageCursor = pagedFile.io(0L, 1);){
                    if (pageCursor.next()) {
                        do {
                            pageCursor.setOffset(0);
                            this.readHeaderAndInitializeRecordFormat(pageCursor);
                        } while (pageCursor.shouldRetry());
                    }
                    break block27;
                }
            }
            this.readHeaderAndInitializeRecordFormat(null);
        }
        this.recordSize = this.determineRecordSize();
    }

    protected long pageIdForRecord(long id) {
        return RecordPageLocationCalculator.pageIdForRecord(id, this.storeFile.pageSize(), this.recordSize);
    }

    protected int offsetForId(long id) {
        return RecordPageLocationCalculator.offsetForId(id, this.storeFile.pageSize(), this.recordSize);
    }

    @Override
    public int getRecordsPerPage() {
        return this.storeFile.pageSize() / this.recordSize;
    }

    public byte[] getRawRecordData(long id) throws IOException {
        byte[] data = new byte[this.recordSize];
        long pageId = RecordPageLocationCalculator.pageIdForRecord(id, this.storeFile.pageSize(), this.recordSize);
        int offset = RecordPageLocationCalculator.offsetForId(id, this.storeFile.pageSize(), this.recordSize);
        try (PageCursor pageCursor = this.storeFile.io(pageId, 1);){
            if (pageCursor.next()) {
                do {
                    pageCursor.setOffset(offset);
                    pageCursor.getBytes(data);
                } while (pageCursor.shouldRetry());
            }
        }
        return data;
    }

    protected void readHeaderAndInitializeRecordFormat(PageCursor cursor) throws IOException {
    }

    private void loadIdGenerator() {
        try {
            if (this.storeOk) {
                this.openIdGenerator();
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk(e);
        }
        finally {
            if (!this.getStoreOk()) {
                this.log.debug(this.getStorageFileName() + " non clean shutdown detected");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInUse(long id) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            boolean recordIsInUse = false;
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    recordIsInUse = this.isInUse(cursor);
                } while (cursor.shouldRetry());
            }
            boolean bl = recordIsInUse;
            return bl;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    final void rebuildIdGenerator() {
        boolean fastRebuild;
        long defraggedCount;
        block16: {
            int blockSize = this.getRecordSize();
            if (blockSize <= 0) {
                throw new InvalidRecordException("Illegal blockSize: " + blockSize);
            }
            this.log.info("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
            this.closeIdGenerator();
            this.createIdGenerator(this.getIdFileName());
            this.openIdGenerator();
            defraggedCount = 0L;
            fastRebuild = this.doFastIdGeneratorRebuild();
            try {
                long foundHighId = this.scanForHighId();
                this.setHighId(foundHighId);
                if (fastRebuild) break block16;
                try (PageCursor cursor = this.storeFile.io(0L, 10);){
                    defraggedCount = this.rebuildIdGeneratorSlow(cursor, this.getRecordsPerPage(), blockSize, foundHighId);
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
            }
        }
        this.log.info("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.log.info(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount);
        if (!fastRebuild) {
            this.closeIdGenerator();
            this.openIdGenerator();
        }
    }

    private long rebuildIdGeneratorSlow(PageCursor cursor, int recordsPerPage, int blockSize, long foundHighId) throws IOException {
        long defragCount = 0L;
        long[] freedBatch = new long[recordsPerPage];
        int startingId = this.getNumberOfReservedLowIds();
        boolean done = false;
        while (!done && cursor.next()) {
            int i;
            int defragged;
            long idPageOffset = cursor.getCurrentPageId() * (long)recordsPerPage;
            block1: do {
                defragged = 0;
                done = false;
                for (i = startingId; i < recordsPerPage; ++i) {
                    int offset = i * blockSize;
                    cursor.setOffset(offset);
                    long recordId = idPageOffset + (long)i;
                    if (recordId >= foundHighId) {
                        done = true;
                        continue block1;
                    }
                    if (!this.isInUse(cursor)) {
                        freedBatch[defragged++] = recordId;
                        continue;
                    }
                    if (!this.isRecordReserved(cursor)) continue;
                    cursor.setOffset(offset);
                    cursor.putByte(Record.NOT_IN_USE.byteValue());
                    cursor.putInt(0);
                    freedBatch[defragged++] = recordId;
                }
            } while (cursor.shouldRetry());
            for (i = 0; i < defragged; ++i) {
                this.freeId(freedBatch[i]);
            }
            defragCount += (long)defragged;
            startingId = 0;
        }
        return defragCount;
    }

    protected boolean doFastIdGeneratorRebuild() {
        return this.configuration.get(Configuration.rebuild_idgenerators_fast);
    }

    protected void setStoreNotOk(Throwable cause) {
        this.storeOk = false;
        this.causeOfStoreNotOk = cause;
        this.idGenerator = null;
    }

    protected boolean getStoreOk() {
        return this.storeOk;
    }

    protected void checkStoreOk() {
        if (!this.storeOk) {
            throw Exceptions.launderedException(this.causeOfStoreNotOk);
        }
    }

    @Override
    public long nextId() {
        return this.idGenerator.nextId();
    }

    public void freeId(long id) {
        IdGenerator generator = this.idGenerator;
        if (generator != null) {
            generator.freeId(id);
        }
    }

    @Override
    public long getHighId() {
        return this.idGenerator != null ? this.idGenerator.getHighId() : this.scanForHighId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighId(long highId) {
        IdGenerator generator = this.idGenerator;
        if (generator != null) {
            IdGenerator idGenerator = generator;
            synchronized (idGenerator) {
                if (highId > generator.getHighId()) {
                    generator.setHighId(highId);
                }
            }
        }
    }

    public void makeStoreOk() {
        if (!this.storeOk) {
            this.rebuildIdGenerator();
            this.storeOk = true;
            this.causeOfStoreNotOk = null;
        }
    }

    @Override
    public File getStorageFileName() {
        return this.storageFileName;
    }

    private File getIdFileName() {
        return new File(this.getStorageFileName().getPath() + ".id");
    }

    protected void openIdGenerator() {
        this.idGenerator = this.openIdGenerator(this.getIdFileName(), this.idType.getGrabSize());
    }

    protected IdGenerator openIdGenerator(File fileName, int grabSize) {
        return this.idGeneratorFactory.open(fileName, grabSize, this.getIdType(), this.scanForHighId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long scanForHighId() {
        try (PageCursor cursor = this.storeFile.io(0L, 1);){
            byte[] expectedLegacyVersionBytes = UTF8.encode(this.typeDescriptor + " " + this.storeVersion);
            long nextPageId = this.storeFile.getLastPageId();
            int recordsPerPage = this.getRecordsPerPage();
            int recordSize = this.getRecordSize();
            while (true) {
                if (nextPageId >= 0L && cursor.next(nextPageId)) {
                    --nextPageId;
                } else {
                    long l = this.getNumberOfReservedLowIds();
                    return l;
                }
                do {
                    int currentRecord = recordsPerPage;
                    while (currentRecord-- > 0) {
                        boolean justLegacyStoreTrailer;
                        int offset = currentRecord * recordSize;
                        cursor.setOffset(offset);
                        long recordId = cursor.getCurrentPageId() * (long)recordsPerPage + (long)currentRecord;
                        if (!this.isInUse(cursor) || (justLegacyStoreTrailer = this.isJustLegacyStoreTrailer(cursor, offset, expectedLegacyVersionBytes, recordSize))) continue;
                        long l = recordId + 1L;
                        return l;
                    }
                } while (cursor.shouldRetry());
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to find high id by scanning backwards " + this.getStorageFileName(), e);
        }
    }

    private boolean isJustLegacyStoreTrailer(PageCursor cursor, int offset, byte[] expectedVersionBytes, int recordSize) {
        try {
            int i = 0;
            while (i < expectedVersionBytes.length) {
                boolean mismatch = false;
                for (int j = 0; i < expectedVersionBytes.length && j < recordSize; ++i, ++j) {
                    byte b = cursor.getByte(offset + j);
                    if (b == expectedVersionBytes[i]) continue;
                    mismatch = true;
                }
                if (mismatch) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    protected abstract int determineRecordSize();

    @Override
    public final int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public int getRecordDataSize() {
        return this.getRecordSize();
    }

    protected abstract boolean isInUse(PageCursor var1);

    protected boolean isRecordReserved(PageCursor cursor) {
        return false;
    }

    protected void createIdGenerator(File fileName) {
        this.idGeneratorFactory.create(fileName, 0L, false);
    }

    protected void closeIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    @Override
    public void flush() {
        try {
            this.storeFile.flushAndForce();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush", e);
        }
    }

    protected void assertNotClosed() {
        if (this.storeFile == null) {
            throw new IllegalStateException(this + " for file '" + this.storageFileName + "' is closed");
        }
    }

    @Override
    public void close() {
        if (this.idGenerator == null || !this.storeOk) {
            try {
                this.closeStoreFile();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
            }
            return;
        }
        try {
            this.closeStoreFile();
        }
        catch (IOException | IllegalStateException e) {
            throw new UnderlyingStorageException("Failed to close store file: " + this.getStorageFileName(), e);
        }
    }

    private void closeStoreFile() throws IOException {
        try {
            this.storeFile.close();
            if (this.idGenerator != null) {
                this.idGenerator.close();
            }
        }
        finally {
            this.storeFile = null;
        }
    }

    @Override
    public long getHighestPossibleIdInUse() {
        return this.idGenerator != null ? this.idGenerator.getHighestPossibleIdInUse() : this.scanForHighId() - 1L;
    }

    @Override
    public void setHighestPossibleIdInUse(long highId) {
        this.setHighId(highId + 1L);
    }

    public long getNumberOfIdsInUse() {
        return this.idGenerator.getNumberOfIdsInUse();
    }

    @Override
    public int getNumberOfReservedLowIds() {
        return 0;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void logVersions(Logger logger) {
        logger.log("  " + this.getTypeDescriptor() + " " + this.storeVersion);
    }

    public void logIdUsage(Logger logger) {
        logger.log(String.format("  %s: used=%s high=%s", this.getTypeDescriptor(), this.getNumberOfIdsInUse(), this.getHighestPossibleIdInUse()));
    }

    public void visitStore(Visitor<CommonAbstractStore<RECORD>, RuntimeException> visitor) {
        visitor.visit((Object)this);
    }

    final void deleteIdGenerator() {
        if (this.idGenerator != null) {
            this.idGenerator.delete();
            this.idGenerator = null;
        }
    }

    @Override
    public long getNextRecordReference(RECORD record) {
        return Record.NULL_REFERENCE.intValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RECORD getRecord(long id, RECORD record, RecordLoad mode) {
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 1);){
            ((AbstractBaseRecord)record).setId(id);
            if (cursor.next(pageId)) {
                do {
                    this.prepareForReading(cursor, offset, record);
                    this.readRecord(cursor, record, mode);
                } while (cursor.shouldRetry());
                this.verifyAfterReading(record, mode);
            } else {
                this.verifyAfterNotRead(record, mode);
            }
            RECORD RECORD = record;
            return RECORD;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected abstract void readRecord(PageCursor var1, RECORD var2, RecordLoad var3) throws IOException;

    @Override
    public void updateRecord(RECORD record) {
        long id = ((AbstractBaseRecord)record).getId();
        long pageId = this.pageIdForRecord(id);
        int offset = this.offsetForId(id);
        try (PageCursor cursor = this.storeFile.io(pageId, 2);){
            if (cursor.next()) {
                do {
                    cursor.setOffset(offset);
                    this.writeRecord(cursor, record);
                } while (cursor.shouldRetry());
                if (!((AbstractBaseRecord)record).inUse()) {
                    this.freeId(id);
                }
                if (!(((AbstractBaseRecord)record).inUse() && ((AbstractBaseRecord)record).requiresSecondaryUnit() || !((AbstractBaseRecord)record).hasSecondaryUnitId())) {
                    this.freeId(((AbstractBaseRecord)record).getSecondaryUnitId());
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected abstract void writeRecord(PageCursor var1, RECORD var2) throws IOException;

    public void scanAllRecords(Visitor<RECORD, IOException> visitor) throws IOException {
        try (RecordCursor cursor = this.newRecordCursor(this.newRecord());){
            long highId = this.getHighId();
            this.placeRecordCursor(this.getNumberOfReservedLowIds(), cursor, RecordLoad.CHECK);
            for (long id = (long)this.getNumberOfReservedLowIds(); id < highId; ++id) {
                if (!cursor.next(id)) continue;
                visitor.visit(cursor.get());
            }
        }
    }

    @Override
    public Collection<RECORD> getRecords(long firstId, RecordLoad mode) {
        try (RecordCursor cursor = this.newRecordCursor(this.newRecord());){
            LinkedList<AbstractBaseRecord> recordList = new LinkedList<AbstractBaseRecord>();
            this.placeRecordCursor(firstId, cursor, mode);
            while (cursor.next()) {
                recordList.add(((AbstractBaseRecord)cursor.get()).clone());
            }
            LinkedList<AbstractBaseRecord> linkedList = recordList;
            return linkedList;
        }
    }

    @Override
    public RecordCursor<RECORD> newRecordCursor(RECORD record) {
        return new RecordCursor<RECORD>((AbstractBaseRecord)record){
            private long currentId;
            private RecordLoad mode;
            private PageCursor pageCursor;
            final /* synthetic */ AbstractBaseRecord val$record;
            {
                this.val$record = abstractBaseRecord;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean next() {
                boolean bl;
                assert (this.pageCursor != null) : "Not initialized";
                if (Record.NULL_REFERENCE.is(this.currentId)) {
                    return false;
                }
                try {
                    this.val$record.setId(this.currentId);
                    long pageId = CommonAbstractStore.this.pageIdForRecord(this.currentId);
                    int offset = CommonAbstractStore.this.offsetForId(this.currentId);
                    if (pageId == this.pageCursor.getCurrentPageId() || this.pageCursor.next(pageId)) {
                        do {
                            CommonAbstractStore.this.prepareForReading(this.pageCursor, offset, this.val$record);
                            CommonAbstractStore.this.readRecord(this.pageCursor, this.val$record, this.mode);
                        } while (this.pageCursor.shouldRetry());
                        CommonAbstractStore.this.verifyAfterReading(this.val$record, this.mode);
                    } else {
                        CommonAbstractStore.this.verifyAfterNotRead(this.val$record, this.mode);
                    }
                    bl = this.val$record.inUse();
                    this.currentId = this.val$record.inUse() ? CommonAbstractStore.this.getNextRecordReference(this.val$record) : (long)Record.NULL_REFERENCE.intValue();
                }
                catch (Throwable throwable) {
                    try {
                        this.currentId = this.val$record.inUse() ? CommonAbstractStore.this.getNextRecordReference(this.val$record) : (long)Record.NULL_REFERENCE.intValue();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UnderlyingStorageException(e);
                    }
                }
                return bl;
            }

            public void close() {
                assert (this.pageCursor != null);
                this.pageCursor.close();
                this.pageCursor = null;
            }

            public RECORD get() {
                return this.val$record;
            }

            @Override
            public boolean next(long id) {
                this.currentId = id;
                return this.next();
            }

            @Override
            public RecordCursor<RECORD> init(long id, RecordLoad mode, PageCursor pageCursor) {
                assert (this.pageCursor == null);
                this.currentId = id;
                this.mode = mode;
                this.pageCursor = pageCursor;
                return this;
            }
        };
    }

    protected void verifyAfterNotRead(RECORD record, RecordLoad mode) {
        ((AbstractBaseRecord)record).clear();
        mode.verify((AbstractBaseRecord)record);
    }

    protected void verifyAfterReading(RECORD record, RecordLoad mode) {
        if (!mode.verify((AbstractBaseRecord)record)) {
            ((AbstractBaseRecord)record).clear();
        }
    }

    protected void prepareForReading(PageCursor cursor, int offset, RECORD record) {
        ((AbstractBaseRecord)record).setInUse(false);
        cursor.setOffset(offset);
    }

    @Override
    public RecordCursor<RECORD> placeRecordCursor(long id, RecordCursor<RECORD> cursor, RecordLoad mode) {
        try {
            PageCursor pageCursor = this.storeFile.io(this.pageIdForRecord(id), 1);
            cursor.init(id, mode, pageCursor);
            return cursor;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void ensureHeavy(RECORD record) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getStoreHeaderInt() {
        throw new UnsupportedOperationException("No header");
    }

    public static abstract class Configuration {
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

