/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV1_9;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_1;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RecordStorageCommandReaderFactory
implements CommandReaderFactory {
    private final CommandReader[] readersNegative;
    private final CommandReader[] readersNeutral = new CommandReader[10];

    public RecordStorageCommandReaderFactory() {
        this.readersNeutral[LogEntryVersion.V1_9.logHeaderFormatVersion()] = new PhysicalLogCommandReaderV1_9();
        this.readersNeutral[LogEntryVersion.V2_0.logHeaderFormatVersion()] = new PhysicalLogCommandReaderV2_0();
        this.readersNegative = new CommandReader[10];
        this.readersNegative[-LogEntryVersion.V2_1.byteCode()] = new PhysicalLogCommandReaderV2_1();
        this.readersNegative[-LogEntryVersion.V2_2.byteCode()] = new PhysicalLogCommandReaderV2_2();
        this.readersNegative[-LogEntryVersion.V2_2_4.byteCode()] = new PhysicalLogCommandReaderV2_2_4();
        this.readersNegative[-LogEntryVersion.V2_3.byteCode()] = new PhysicalLogCommandReaderV2_2_4();
        this.readersNegative[-LogEntryVersion.V3_0.byteCode()] = new PhysicalLogCommandReaderV3_0();
        LogEntryVersion[] versions = LogEntryVersion.values();
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i] != null) continue;
            throw new IllegalStateException("Version " + (Object)((Object)versions[i]) + " not handled");
        }
    }

    @Override
    public CommandReader byVersion(byte version, byte legacyHeaderVersion) {
        CommandReader[] readers = null;
        byte key = 0;
        if (version == 0) {
            readers = this.readersNeutral;
            key = legacyHeaderVersion;
        } else if (version < 0) {
            readers = this.readersNegative;
            key = (byte)Math.abs(version);
        }
        if (readers == null || key >= readers.length) {
            throw new IllegalArgumentException("Unsupported version:" + version + " headerVersion:" + legacyHeaderVersion);
        }
        return readers[key];
    }
}

