/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.api.store.StorePropertyPayloadCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.PropertyItem;

public class StorePropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private final PropertyStore propertyStore;
    private final Consumer<StorePropertyCursor> instanceCache;
    private final StorePropertyPayloadCursor payload;
    private final RecordCursor<PropertyRecord> recordCursor;
    private Lock lock;

    public StorePropertyCursor(PropertyStore propertyStore, Consumer<StorePropertyCursor> instanceCache) {
        this.propertyStore = propertyStore;
        this.instanceCache = instanceCache;
        this.payload = new StorePropertyPayloadCursor(propertyStore.getStringStore(), propertyStore.getArrayStore());
        this.recordCursor = propertyStore.newRecordCursor(propertyStore.newRecord());
    }

    public StorePropertyCursor init(long firstPropertyId, Lock lock) {
        this.lock = lock;
        this.propertyStore.placeRecordCursor(firstPropertyId, this.recordCursor, RecordLoad.NORMAL);
        this.payload.clear();
        return this;
    }

    public boolean next() {
        if (this.payload.next()) {
            return true;
        }
        if (!this.recordCursor.next()) {
            return false;
        }
        PropertyRecord propertyRecord = (PropertyRecord)this.recordCursor.get();
        this.payload.init(propertyRecord.getBlocks(), propertyRecord.getNumberOfBlocks());
        if (!this.payload.next()) {
            throw new NotFoundException("Property record with id " + propertyRecord.getId() + " not in use");
        }
        return true;
    }

    @Override
    public int propertyKeyId() {
        return this.payload.propertyKeyId();
    }

    @Override
    public Object value() {
        return this.payload.value();
    }

    public PropertyItem get() {
        return this;
    }

    public void close() {
        try {
            this.payload.clear();
            this.instanceCache.accept(this);
            this.recordCursor.close();
        }
        finally {
            this.lock.release();
        }
    }
}

